package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  ListMetricStreamsMaxResults,
  NextToken
}
import scala.jdk.CollectionConverters._
final case class ListMetricStreamsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListMetricStreamsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest = {
    import ListMetricStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListMetricStreamsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ListMetricStreamsRequest.ReadOnly =
    zio.aws.cloudwatch.model.ListMetricStreamsRequest.wrap(buildAwsValue())
}
object ListMetricStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListMetricStreamsRequest =
      zio.aws.cloudwatch.model.ListMetricStreamsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListMetricStreamsMaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMetricStreamsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest
  ) extends zio.aws.cloudwatch.model.ListMetricStreamsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val maxResults: Optional[ListMetricStreamsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.ListMetricStreamsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest
  ): zio.aws.cloudwatch.model.ListMetricStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
