package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  MetricName,
  NextToken,
  AccountId,
  Namespace,
  IncludeLinkedAccounts
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMetricsRequest(
    namespace: Optional[Namespace] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.DimensionFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    recentlyActive: Optional[zio.aws.cloudwatch.model.RecentlyActive] =
      Optional.Absent,
    includeLinkedAccounts: Optional[IncludeLinkedAccounts] = Optional.Absent,
    owningAccount: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest = {
    import ListMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
      .builder()
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(recentlyActive.map(value => value.unwrap))(
        _.recentlyActive
      )
      .optionallyWith(
        includeLinkedAccounts.map(value =>
          IncludeLinkedAccounts.unwrap(value): java.lang.Boolean
        )
      )(_.includeLinkedAccounts)
      .optionallyWith(
        owningAccount.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.owningAccount)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ListMetricsRequest.ReadOnly =
    zio.aws.cloudwatch.model.ListMetricsRequest.wrap(buildAwsValue())
}
object ListMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListMetricsRequest =
      zio.aws.cloudwatch.model.ListMetricsRequest(
        namespace.map(value => value),
        metricName.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        recentlyActive.map(value => value),
        includeLinkedAccounts.map(value => value),
        owningAccount.map(value => value)
      )
    def namespace: Optional[Namespace]
    def metricName: Optional[MetricName]
    def dimensions
        : Optional[List[zio.aws.cloudwatch.model.DimensionFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def recentlyActive: Optional[zio.aws.cloudwatch.model.RecentlyActive]
    def includeLinkedAccounts: Optional[IncludeLinkedAccounts]
    def owningAccount: Optional[AccountId]
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.DimensionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecentlyActive
        : ZIO[Any, AwsError, zio.aws.cloudwatch.model.RecentlyActive] =
      AwsError.unwrapOptionField("recentlyActive", recentlyActive)
    def getIncludeLinkedAccounts: ZIO[Any, AwsError, IncludeLinkedAccounts] =
      AwsError.unwrapOptionField("includeLinkedAccounts", includeLinkedAccounts)
    def getOwningAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("owningAccount", owningAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
  ) extends zio.aws.cloudwatch.model.ListMetricsRequest.ReadOnly {
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricName(value))
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.DimensionFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.DimensionFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val recentlyActive
        : Optional[zio.aws.cloudwatch.model.RecentlyActive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recentlyActive())
        .map(value => zio.aws.cloudwatch.model.RecentlyActive.wrap(value))
    override val includeLinkedAccounts: Optional[IncludeLinkedAccounts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeLinkedAccounts())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.IncludeLinkedAccounts(value)
        )
    override val owningAccount: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.owningAccount())
      .map(value => zio.aws.cloudwatch.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
  ): zio.aws.cloudwatch.model.ListMetricsRequest.ReadOnly = new Wrapper(impl)
}
