package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{AccountId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMetricsResponse(
    metrics: Optional[Iterable[zio.aws.cloudwatch.model.Metric]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    owningAccounts: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse = {
    import ListMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
      .builder()
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        owningAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.owningAccounts)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly =
    zio.aws.cloudwatch.model.ListMetricsResponse.wrap(buildAwsValue())
}
object ListMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.ListMetricsResponse =
      zio.aws.cloudwatch.model.ListMetricsResponse(
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        owningAccounts.map(value => value)
      )
    def metrics: Optional[List[zio.aws.cloudwatch.model.Metric.ReadOnly]]
    def nextToken: Optional[NextToken]
    def owningAccounts: Optional[List[AccountId]]
    def getMetrics
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Metric.ReadOnly]] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwningAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("owningAccounts", owningAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
  ) extends zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly {
    override val metrics
        : Optional[List[zio.aws.cloudwatch.model.Metric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Metric.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudwatch.model.primitives.NextToken(value))
    override val owningAccounts: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owningAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.AccountId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
  ): zio.aws.cloudwatch.model.ListMetricsResponse.ReadOnly = new Wrapper(impl)
}
