package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{MessageDataValue, MessageDataCode}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MessageData(
    code: Optional[MessageDataCode] = Optional.Absent,
    value: Optional[MessageDataValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.MessageData = {
    import MessageData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.MessageData
      .builder()
      .optionallyWith(
        code.map(value => MessageDataCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        value.map(value => MessageDataValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.MessageData.ReadOnly =
    zio.aws.cloudwatch.model.MessageData.wrap(buildAwsValue())
}
object MessageData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.MessageData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.MessageData =
      zio.aws.cloudwatch.model
        .MessageData(code.map(value => value), value.map(value => value))
    def code: Optional[MessageDataCode]
    def value: Optional[MessageDataValue]
    def getCode: ZIO[Any, AwsError, MessageDataCode] =
      AwsError.unwrapOptionField("code", code)
    def getValue: ZIO[Any, AwsError, MessageDataValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.MessageData
  ) extends zio.aws.cloudwatch.model.MessageData.ReadOnly {
    override val code: Optional[MessageDataCode] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.cloudwatch.model.primitives.MessageDataCode(value))
    override val value: Optional[MessageDataValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.cloudwatch.model.primitives.MessageDataValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.MessageData
  ): zio.aws.cloudwatch.model.MessageData.ReadOnly = new Wrapper(impl)
}
