package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{MetricName, Namespace}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Metric(
    namespace: Optional[Namespace] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Metric = {
    import Metric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Metric
      .builder()
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.Metric.ReadOnly =
    zio.aws.cloudwatch.model.Metric.wrap(buildAwsValue())
}
object Metric {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudwatch.model.Metric] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.Metric =
      zio.aws.cloudwatch.model.Metric(
        namespace.map(value => value),
        metricName.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def namespace: Optional[Namespace]
    def metricName: Optional[MetricName]
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Metric
  ) extends zio.aws.cloudwatch.model.Metric.ReadOnly {
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricName(value))
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Metric
  ): zio.aws.cloudwatch.model.Metric.ReadOnly = new Wrapper(impl)
}
