package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  FailureDescription,
  FailureCode,
  ExceptionType,
  FailureResource
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PartialFailure(
    failureResource: Optional[FailureResource] = Optional.Absent,
    exceptionType: Optional[ExceptionType] = Optional.Absent,
    failureCode: Optional[FailureCode] = Optional.Absent,
    failureDescription: Optional[FailureDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PartialFailure = {
    import PartialFailure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PartialFailure
      .builder()
      .optionallyWith(
        failureResource.map(value =>
          FailureResource.unwrap(value): java.lang.String
        )
      )(_.failureResource)
      .optionallyWith(
        exceptionType.map(value =>
          ExceptionType.unwrap(value): java.lang.String
        )
      )(_.exceptionType)
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureDescription.map(value =>
          FailureDescription.unwrap(value): java.lang.String
        )
      )(_.failureDescription)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PartialFailure.ReadOnly =
    zio.aws.cloudwatch.model.PartialFailure.wrap(buildAwsValue())
}
object PartialFailure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PartialFailure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PartialFailure =
      zio.aws.cloudwatch.model.PartialFailure(
        failureResource.map(value => value),
        exceptionType.map(value => value),
        failureCode.map(value => value),
        failureDescription.map(value => value)
      )
    def failureResource: Optional[FailureResource]
    def exceptionType: Optional[ExceptionType]
    def failureCode: Optional[FailureCode]
    def failureDescription: Optional[FailureDescription]
    def getFailureResource: ZIO[Any, AwsError, FailureResource] =
      AwsError.unwrapOptionField("failureResource", failureResource)
    def getExceptionType: ZIO[Any, AwsError, ExceptionType] =
      AwsError.unwrapOptionField("exceptionType", exceptionType)
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureDescription: ZIO[Any, AwsError, FailureDescription] =
      AwsError.unwrapOptionField("failureDescription", failureDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PartialFailure
  ) extends zio.aws.cloudwatch.model.PartialFailure.ReadOnly {
    override val failureResource: Optional[FailureResource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureResource())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.FailureResource(value)
        )
    override val exceptionType: Optional[ExceptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.exceptionType())
      .map(value => zio.aws.cloudwatch.model.primitives.ExceptionType(value))
    override val failureCode: Optional[FailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.cloudwatch.model.primitives.FailureCode(value))
    override val failureDescription: Optional[FailureDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDescription())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.FailureDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PartialFailure
  ): zio.aws.cloudwatch.model.PartialFailure.ReadOnly = new Wrapper(impl)
}
