package zio.aws.cloudwatch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutManagedInsightRulesRequest(
    managedRules: Iterable[zio.aws.cloudwatch.model.ManagedRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest = {
    import PutManagedInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
      .builder()
      .managedRules(managedRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudwatch.model.PutManagedInsightRulesRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutManagedInsightRulesRequest.wrap(buildAwsValue())
}
object PutManagedInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutManagedInsightRulesRequest =
      zio.aws.cloudwatch.model.PutManagedInsightRulesRequest(managedRules.map {
        item =>
          item.asEditable
      })
    def managedRules: List[zio.aws.cloudwatch.model.ManagedRule.ReadOnly]
    def getManagedRules: ZIO[Any, Nothing, List[
      zio.aws.cloudwatch.model.ManagedRule.ReadOnly
    ]] = ZIO.succeed(managedRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
  ) extends zio.aws.cloudwatch.model.PutManagedInsightRulesRequest.ReadOnly {
    override val managedRules
        : List[zio.aws.cloudwatch.model.ManagedRule.ReadOnly] = impl
      .managedRules()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.ManagedRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest
  ): zio.aws.cloudwatch.model.PutManagedInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
