package zio.aws.cloudwatch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.cloudwatch.model.primitives.{
  MetricName,
  ExtendedStatistic,
  DatapointsToAlarm,
  ActionsEnabled,
  Namespace,
  AlarmName,
  EvaluateLowSampleCountPercentile,
  Period,
  MetricId,
  EvaluationPeriods,
  AlarmDescription,
  TreatMissingData,
  ResourceName,
  Threshold
}
import scala.jdk.CollectionConverters._
final case class PutMetricAlarmRequest(
    alarmName: AlarmName,
    alarmDescription: Optional[AlarmDescription] = Optional.Absent,
    actionsEnabled: Optional[ActionsEnabled] = Optional.Absent,
    okActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    alarmActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    insufficientDataActions: Optional[Iterable[ResourceName]] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    namespace: Optional[Namespace] = Optional.Absent,
    statistic: Optional[zio.aws.cloudwatch.model.Statistic] = Optional.Absent,
    extendedStatistic: Optional[ExtendedStatistic] = Optional.Absent,
    dimensions: Optional[Iterable[zio.aws.cloudwatch.model.Dimension]] =
      Optional.Absent,
    period: Optional[Period] = Optional.Absent,
    unit: Optional[zio.aws.cloudwatch.model.StandardUnit] = Optional.Absent,
    evaluationPeriods: EvaluationPeriods,
    datapointsToAlarm: Optional[DatapointsToAlarm] = Optional.Absent,
    threshold: Optional[Threshold] = Optional.Absent,
    comparisonOperator: zio.aws.cloudwatch.model.ComparisonOperator,
    treatMissingData: Optional[TreatMissingData] = Optional.Absent,
    evaluateLowSampleCountPercentile: Optional[
      EvaluateLowSampleCountPercentile
    ] = Optional.Absent,
    metrics: Optional[Iterable[zio.aws.cloudwatch.model.MetricDataQuery]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudwatch.model.Tag]] = Optional.Absent,
    thresholdMetricId: Optional[MetricId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest = {
    import PutMetricAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
      .builder()
      .alarmName(AlarmName.unwrap(alarmName): java.lang.String)
      .optionallyWith(
        alarmDescription.map(value =>
          AlarmDescription.unwrap(value): java.lang.String
        )
      )(_.alarmDescription)
      .optionallyWith(
        actionsEnabled.map(value =>
          ActionsEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.actionsEnabled)
      .optionallyWith(
        okActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.okActions)
      .optionallyWith(
        alarmActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.alarmActions)
      .optionallyWith(
        insufficientDataActions.map(value =>
          value.map { item =>
            ResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.insufficientDataActions)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        extendedStatistic.map(value =>
          ExtendedStatistic.unwrap(value): java.lang.String
        )
      )(_.extendedStatistic)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(period.map(value => Period.unwrap(value): Integer))(
        _.period
      )
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .evaluationPeriods(EvaluationPeriods.unwrap(evaluationPeriods): Integer)
      .optionallyWith(
        datapointsToAlarm.map(value => DatapointsToAlarm.unwrap(value): Integer)
      )(_.datapointsToAlarm)
      .optionallyWith(
        threshold.map(value => Threshold.unwrap(value): java.lang.Double)
      )(_.threshold)
      .comparisonOperator(comparisonOperator.unwrap)
      .optionallyWith(
        treatMissingData.map(value =>
          TreatMissingData.unwrap(value): java.lang.String
        )
      )(_.treatMissingData)
      .optionallyWith(
        evaluateLowSampleCountPercentile.map(value =>
          EvaluateLowSampleCountPercentile.unwrap(value): java.lang.String
        )
      )(_.evaluateLowSampleCountPercentile)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        thresholdMetricId.map(value => MetricId.unwrap(value): java.lang.String)
      )(_.thresholdMetricId)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutMetricAlarmRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutMetricAlarmRequest.wrap(buildAwsValue())
}
object PutMetricAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutMetricAlarmRequest =
      zio.aws.cloudwatch.model.PutMetricAlarmRequest(
        alarmName,
        alarmDescription.map(value => value),
        actionsEnabled.map(value => value),
        okActions.map(value => value),
        alarmActions.map(value => value),
        insufficientDataActions.map(value => value),
        metricName.map(value => value),
        namespace.map(value => value),
        statistic.map(value => value),
        extendedStatistic.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        period.map(value => value),
        unit.map(value => value),
        evaluationPeriods,
        datapointsToAlarm.map(value => value),
        threshold.map(value => value),
        comparisonOperator,
        treatMissingData.map(value => value),
        evaluateLowSampleCountPercentile.map(value => value),
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        thresholdMetricId.map(value => value)
      )
    def alarmName: AlarmName
    def alarmDescription: Optional[AlarmDescription]
    def actionsEnabled: Optional[ActionsEnabled]
    def okActions: Optional[List[ResourceName]]
    def alarmActions: Optional[List[ResourceName]]
    def insufficientDataActions: Optional[List[ResourceName]]
    def metricName: Optional[MetricName]
    def namespace: Optional[Namespace]
    def statistic: Optional[zio.aws.cloudwatch.model.Statistic]
    def extendedStatistic: Optional[ExtendedStatistic]
    def dimensions: Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]]
    def period: Optional[Period]
    def unit: Optional[zio.aws.cloudwatch.model.StandardUnit]
    def evaluationPeriods: EvaluationPeriods
    def datapointsToAlarm: Optional[DatapointsToAlarm]
    def threshold: Optional[Threshold]
    def comparisonOperator: zio.aws.cloudwatch.model.ComparisonOperator
    def treatMissingData: Optional[TreatMissingData]
    def evaluateLowSampleCountPercentile
        : Optional[EvaluateLowSampleCountPercentile]
    def metrics
        : Optional[List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]]
    def tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]]
    def thresholdMetricId: Optional[MetricId]
    def getAlarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmName)
    def getAlarmDescription: ZIO[Any, AwsError, AlarmDescription] =
      AwsError.unwrapOptionField("alarmDescription", alarmDescription)
    def getActionsEnabled: ZIO[Any, AwsError, ActionsEnabled] =
      AwsError.unwrapOptionField("actionsEnabled", actionsEnabled)
    def getOkActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("okActions", okActions)
    def getAlarmActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField("alarmActions", alarmActions)
    def getInsufficientDataActions: ZIO[Any, AwsError, List[ResourceName]] =
      AwsError.unwrapOptionField(
        "insufficientDataActions",
        insufficientDataActions
      )
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getStatistic: ZIO[Any, AwsError, zio.aws.cloudwatch.model.Statistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getExtendedStatistic: ZIO[Any, AwsError, ExtendedStatistic] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatistic)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getPeriod: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", period)
    def getUnit: ZIO[Any, AwsError, zio.aws.cloudwatch.model.StandardUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getEvaluationPeriods: ZIO[Any, Nothing, EvaluationPeriods] =
      ZIO.succeed(evaluationPeriods)
    def getDatapointsToAlarm: ZIO[Any, AwsError, DatapointsToAlarm] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarm)
    def getThreshold: ZIO[Any, AwsError, Threshold] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.cloudwatch.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getTreatMissingData: ZIO[Any, AwsError, TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingData)
    def getEvaluateLowSampleCountPercentile
        : ZIO[Any, AwsError, EvaluateLowSampleCountPercentile] =
      AwsError.unwrapOptionField(
        "evaluateLowSampleCountPercentile",
        evaluateLowSampleCountPercentile
      )
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getThresholdMetricId: ZIO[Any, AwsError, MetricId] =
      AwsError.unwrapOptionField("thresholdMetricId", thresholdMetricId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
  ) extends zio.aws.cloudwatch.model.PutMetricAlarmRequest.ReadOnly {
    override val alarmName: AlarmName =
      zio.aws.cloudwatch.model.primitives.AlarmName(impl.alarmName())
    override val alarmDescription: Optional[AlarmDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmDescription())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.AlarmDescription(value)
        )
    override val actionsEnabled: Optional[ActionsEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionsEnabled())
        .map(value => zio.aws.cloudwatch.model.primitives.ActionsEnabled(value))
    override val okActions: Optional[List[ResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.okActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudwatch.model.primitives.ResourceName(item)
        }.toList
      )
    override val alarmActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val insufficientDataActions: Optional[List[ResourceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insufficientDataActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.primitives.ResourceName(item)
          }.toList
        )
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricName(value))
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.cloudwatch.model.primitives.Namespace(value))
    override val statistic: Optional[zio.aws.cloudwatch.model.Statistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.cloudwatch.model.Statistic.wrap(value))
    override val extendedStatistic: Optional[ExtendedStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedStatistic())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.ExtendedStatistic(value)
        )
    override val dimensions
        : Optional[List[zio.aws.cloudwatch.model.Dimension.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Dimension.wrap(item)
          }.toList
        )
    override val period: Optional[Period] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.cloudwatch.model.primitives.Period(value))
    override val unit: Optional[zio.aws.cloudwatch.model.StandardUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.cloudwatch.model.StandardUnit.wrap(value))
    override val evaluationPeriods: EvaluationPeriods =
      zio.aws.cloudwatch.model.primitives
        .EvaluationPeriods(impl.evaluationPeriods())
    override val datapointsToAlarm: Optional[DatapointsToAlarm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datapointsToAlarm())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.DatapointsToAlarm(value)
        )
    override val threshold: Optional[Threshold] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => zio.aws.cloudwatch.model.primitives.Threshold(value))
    override val comparisonOperator
        : zio.aws.cloudwatch.model.ComparisonOperator =
      zio.aws.cloudwatch.model.ComparisonOperator
        .wrap(impl.comparisonOperator())
    override val treatMissingData: Optional[TreatMissingData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatMissingData())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.TreatMissingData(value)
        )
    override val evaluateLowSampleCountPercentile
        : Optional[EvaluateLowSampleCountPercentile] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluateLowSampleCountPercentile())
      .map(value =>
        zio.aws.cloudwatch.model.primitives
          .EvaluateLowSampleCountPercentile(value)
      )
    override val metrics
        : Optional[List[zio.aws.cloudwatch.model.MetricDataQuery.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.MetricDataQuery.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
    override val thresholdMetricId: Optional[MetricId] = zio.aws.core.internal
      .optionalFromNullable(impl.thresholdMetricId())
      .map(value => zio.aws.cloudwatch.model.primitives.MetricId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest
  ): zio.aws.cloudwatch.model.PutMetricAlarmRequest.ReadOnly = new Wrapper(impl)
}
