package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.Namespace
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutMetricDataRequest(
    namespace: Namespace,
    metricData: Iterable[zio.aws.cloudwatch.model.MetricDatum]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest = {
    import PutMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
      .builder()
      .namespace(Namespace.unwrap(namespace): java.lang.String)
      .metricData(metricData.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.PutMetricDataRequest.ReadOnly =
    zio.aws.cloudwatch.model.PutMetricDataRequest.wrap(buildAwsValue())
}
object PutMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.PutMetricDataRequest =
      zio.aws.cloudwatch.model.PutMetricDataRequest(
        namespace,
        metricData.map { item =>
          item.asEditable
        }
      )
    def namespace: Namespace
    def metricData: List[zio.aws.cloudwatch.model.MetricDatum.ReadOnly]
    def getNamespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespace)
    def getMetricData: ZIO[Any, Nothing, List[
      zio.aws.cloudwatch.model.MetricDatum.ReadOnly
    ]] = ZIO.succeed(metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
  ) extends zio.aws.cloudwatch.model.PutMetricDataRequest.ReadOnly {
    override val namespace: Namespace =
      zio.aws.cloudwatch.model.primitives.Namespace(impl.namespace())
    override val metricData
        : List[zio.aws.cloudwatch.model.MetricDatum.ReadOnly] = impl
      .metricData()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.MetricDatum.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest
  ): zio.aws.cloudwatch.model.PutMetricDataRequest.ReadOnly = new Wrapper(impl)
}
