package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Range(startTime: Timestamp, endTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Range
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.Range.ReadOnly =
    zio.aws.cloudwatch.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.cloudwatch.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.Range =
      zio.aws.cloudwatch.model.Range(startTime, endTime)
    def startTime: Timestamp
    def endTime: Timestamp
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Range
  ) extends zio.aws.cloudwatch.model.Range.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.cloudwatch.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Range
  ): zio.aws.cloudwatch.model.Range.ReadOnly = new Wrapper(impl)
}
