package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.{
  StateReasonData,
  StateReason,
  AlarmName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetAlarmStateRequest(
    alarmName: AlarmName,
    stateValue: zio.aws.cloudwatch.model.StateValue,
    stateReason: StateReason,
    stateReasonData: Optional[StateReasonData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest = {
    import SetAlarmStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
      .builder()
      .alarmName(AlarmName.unwrap(alarmName): java.lang.String)
      .stateValue(stateValue.unwrap)
      .stateReason(StateReason.unwrap(stateReason): java.lang.String)
      .optionallyWith(
        stateReasonData.map(value =>
          StateReasonData.unwrap(value): java.lang.String
        )
      )(_.stateReasonData)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.SetAlarmStateRequest.ReadOnly =
    zio.aws.cloudwatch.model.SetAlarmStateRequest.wrap(buildAwsValue())
}
object SetAlarmStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.SetAlarmStateRequest =
      zio.aws.cloudwatch.model.SetAlarmStateRequest(
        alarmName,
        stateValue,
        stateReason,
        stateReasonData.map(value => value)
      )
    def alarmName: AlarmName
    def stateValue: zio.aws.cloudwatch.model.StateValue
    def stateReason: StateReason
    def stateReasonData: Optional[StateReasonData]
    def getAlarmName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(alarmName)
    def getStateValue: ZIO[Any, Nothing, zio.aws.cloudwatch.model.StateValue] =
      ZIO.succeed(stateValue)
    def getStateReason: ZIO[Any, Nothing, StateReason] =
      ZIO.succeed(stateReason)
    def getStateReasonData: ZIO[Any, AwsError, StateReasonData] =
      AwsError.unwrapOptionField("stateReasonData", stateReasonData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
  ) extends zio.aws.cloudwatch.model.SetAlarmStateRequest.ReadOnly {
    override val alarmName: AlarmName =
      zio.aws.cloudwatch.model.primitives.AlarmName(impl.alarmName())
    override val stateValue: zio.aws.cloudwatch.model.StateValue =
      zio.aws.cloudwatch.model.StateValue.wrap(impl.stateValue())
    override val stateReason: StateReason =
      zio.aws.cloudwatch.model.primitives.StateReason(impl.stateReason())
    override val stateReasonData: Optional[StateReasonData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReasonData())
        .map(value =>
          zio.aws.cloudwatch.model.primitives.StateReasonData(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest
  ): zio.aws.cloudwatch.model.SetAlarmStateRequest.ReadOnly = new Wrapper(impl)
}
