package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopMetricStreamsRequest(names: Iterable[MetricStreamName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest = {
    import StopMetricStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
      .builder()
      .names(names.map { item =>
        MetricStreamName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.StopMetricStreamsRequest.ReadOnly =
    zio.aws.cloudwatch.model.StopMetricStreamsRequest.wrap(buildAwsValue())
}
object StopMetricStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.StopMetricStreamsRequest =
      zio.aws.cloudwatch.model.StopMetricStreamsRequest(names)
    def names: List[MetricStreamName]
    def getNames: ZIO[Any, Nothing, List[MetricStreamName]] = ZIO.succeed(names)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
  ) extends zio.aws.cloudwatch.model.StopMetricStreamsRequest.ReadOnly {
    override val names: List[MetricStreamName] = impl
      .names()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.primitives.MetricStreamName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest
  ): zio.aws.cloudwatch.model.StopMetricStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
