package zio.aws.cloudwatch.model
import zio.aws.cloudwatch.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: AmazonResourceName,
    tags: Iterable[zio.aws.cloudwatch.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudwatch.model.TagResourceRequest.ReadOnly =
    zio.aws.cloudwatch.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudwatch.model.TagResourceRequest =
      zio.aws.cloudwatch.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: AmazonResourceName
    def tags: List[zio.aws.cloudwatch.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.cloudwatch.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
  ) extends zio.aws.cloudwatch.model.TagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.cloudwatch.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tags: List[zio.aws.cloudwatch.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.cloudwatch.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest
  ): zio.aws.cloudwatch.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
