package zio.aws.cloudwatch
import zio.aws.cloudwatch.model.primitives.NextToken.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.cloudwatch.model.primitives.{
  ExtendedStatistic,
  AccountId,
  InsightRuleContributorKeyLabel,
  AlarmName,
  Timestamp,
  InsightRuleContributorKey,
  InsightRuleMetricName,
  MetricStreamName,
  MetricStreamStatistic,
  DashboardName,
  InsightRuleName,
  DatapointValue,
  ResourceName,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.cloudwatch.model.primitives.AccountId.Type
    object ActionPrefix extends Subtype[String]
    type ActionPrefix = zio.aws.cloudwatch.model.primitives.ActionPrefix.Type
    object ActionsEnabled extends Subtype[Boolean]
    type ActionsEnabled =
      zio.aws.cloudwatch.model.primitives.ActionsEnabled.Type
    object ActionsSuppressedReason extends Subtype[String]
    type ActionsSuppressedReason =
      zio.aws.cloudwatch.model.primitives.ActionsSuppressedReason.Type
    object AlarmArn extends Subtype[String]
    type AlarmArn = zio.aws.cloudwatch.model.primitives.AlarmArn.Type
    object AlarmDescription extends Subtype[String]
    type AlarmDescription =
      zio.aws.cloudwatch.model.primitives.AlarmDescription.Type
    object AlarmName extends Subtype[String]
    type AlarmName = zio.aws.cloudwatch.model.primitives.AlarmName.Type
    object AlarmNamePrefix extends Subtype[String]
    type AlarmNamePrefix =
      zio.aws.cloudwatch.model.primitives.AlarmNamePrefix.Type
    object AlarmRule extends Subtype[String]
    type AlarmRule = zio.aws.cloudwatch.model.primitives.AlarmRule.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.cloudwatch.model.primitives.AmazonResourceName.Type
    object AnomalyDetectorMetricStat extends Subtype[String]
    type AnomalyDetectorMetricStat =
      zio.aws.cloudwatch.model.primitives.AnomalyDetectorMetricStat.Type
    object AnomalyDetectorMetricTimezone extends Subtype[String]
    type AnomalyDetectorMetricTimezone =
      zio.aws.cloudwatch.model.primitives.AnomalyDetectorMetricTimezone.Type
    object DashboardArn extends Subtype[String]
    type DashboardArn = zio.aws.cloudwatch.model.primitives.DashboardArn.Type
    object DashboardBody extends Subtype[String]
    type DashboardBody = zio.aws.cloudwatch.model.primitives.DashboardBody.Type
    object DashboardName extends Subtype[String]
    type DashboardName = zio.aws.cloudwatch.model.primitives.DashboardName.Type
    object DashboardNamePrefix extends Subtype[String]
    type DashboardNamePrefix =
      zio.aws.cloudwatch.model.primitives.DashboardNamePrefix.Type
    object DataPath extends Subtype[String]
    type DataPath = zio.aws.cloudwatch.model.primitives.DataPath.Type
    object DatapointValue extends Subtype[Double]
    type DatapointValue =
      zio.aws.cloudwatch.model.primitives.DatapointValue.Type
    object DatapointsToAlarm extends Subtype[Int]
    type DatapointsToAlarm =
      zio.aws.cloudwatch.model.primitives.DatapointsToAlarm.Type
    object DimensionName extends Subtype[String]
    type DimensionName = zio.aws.cloudwatch.model.primitives.DimensionName.Type
    object DimensionValue extends Subtype[String]
    type DimensionValue =
      zio.aws.cloudwatch.model.primitives.DimensionValue.Type
    object EvaluateLowSampleCountPercentile extends Subtype[String]
    type EvaluateLowSampleCountPercentile =
      zio.aws.cloudwatch.model.primitives.EvaluateLowSampleCountPercentile.Type
    object EvaluationPeriods extends Subtype[Int]
    type EvaluationPeriods =
      zio.aws.cloudwatch.model.primitives.EvaluationPeriods.Type
    object ExceptionType extends Subtype[String]
    type ExceptionType = zio.aws.cloudwatch.model.primitives.ExceptionType.Type
    object ExtendedStatistic extends Subtype[String]
    type ExtendedStatistic =
      zio.aws.cloudwatch.model.primitives.ExtendedStatistic.Type
    object FailureCode extends Subtype[String]
    type FailureCode = zio.aws.cloudwatch.model.primitives.FailureCode.Type
    object FailureDescription extends Subtype[String]
    type FailureDescription =
      zio.aws.cloudwatch.model.primitives.FailureDescription.Type
    object FailureResource extends Subtype[String]
    type FailureResource =
      zio.aws.cloudwatch.model.primitives.FailureResource.Type
    object GetMetricDataLabelTimezone extends Subtype[String]
    type GetMetricDataLabelTimezone =
      zio.aws.cloudwatch.model.primitives.GetMetricDataLabelTimezone.Type
    object GetMetricDataMaxDatapoints extends Subtype[Int]
    type GetMetricDataMaxDatapoints =
      zio.aws.cloudwatch.model.primitives.GetMetricDataMaxDatapoints.Type
    object HistoryData extends Subtype[String]
    type HistoryData = zio.aws.cloudwatch.model.primitives.HistoryData.Type
    object HistorySummary extends Subtype[String]
    type HistorySummary =
      zio.aws.cloudwatch.model.primitives.HistorySummary.Type
    object IncludeLinkedAccounts extends Subtype[Boolean]
    type IncludeLinkedAccounts =
      zio.aws.cloudwatch.model.primitives.IncludeLinkedAccounts.Type
    object IncludeLinkedAccountsMetrics extends Subtype[Boolean]
    type IncludeLinkedAccountsMetrics =
      zio.aws.cloudwatch.model.primitives.IncludeLinkedAccountsMetrics.Type
    object InsightRuleAggregationStatistic extends Subtype[String]
    type InsightRuleAggregationStatistic =
      zio.aws.cloudwatch.model.primitives.InsightRuleAggregationStatistic.Type
    object InsightRuleContributorKey extends Subtype[String]
    type InsightRuleContributorKey =
      zio.aws.cloudwatch.model.primitives.InsightRuleContributorKey.Type
    object InsightRuleContributorKeyLabel extends Subtype[String]
    type InsightRuleContributorKeyLabel =
      zio.aws.cloudwatch.model.primitives.InsightRuleContributorKeyLabel.Type
    object InsightRuleDefinition extends Subtype[String]
    type InsightRuleDefinition =
      zio.aws.cloudwatch.model.primitives.InsightRuleDefinition.Type
    object InsightRuleIsManaged extends Subtype[Boolean]
    type InsightRuleIsManaged =
      zio.aws.cloudwatch.model.primitives.InsightRuleIsManaged.Type
    object InsightRuleMaxResults extends Subtype[Int]
    type InsightRuleMaxResults =
      zio.aws.cloudwatch.model.primitives.InsightRuleMaxResults.Type
    object InsightRuleMetricName extends Subtype[String]
    type InsightRuleMetricName =
      zio.aws.cloudwatch.model.primitives.InsightRuleMetricName.Type
    object InsightRuleName extends Subtype[String]
    type InsightRuleName =
      zio.aws.cloudwatch.model.primitives.InsightRuleName.Type
    object InsightRuleOrderBy extends Subtype[String]
    type InsightRuleOrderBy =
      zio.aws.cloudwatch.model.primitives.InsightRuleOrderBy.Type
    object InsightRuleSchema extends Subtype[String]
    type InsightRuleSchema =
      zio.aws.cloudwatch.model.primitives.InsightRuleSchema.Type
    object InsightRuleState extends Subtype[String]
    type InsightRuleState =
      zio.aws.cloudwatch.model.primitives.InsightRuleState.Type
    object InsightRuleUnboundDouble extends Subtype[Double]
    type InsightRuleUnboundDouble =
      zio.aws.cloudwatch.model.primitives.InsightRuleUnboundDouble.Type
    object InsightRuleUnboundInteger extends Subtype[Int]
    type InsightRuleUnboundInteger =
      zio.aws.cloudwatch.model.primitives.InsightRuleUnboundInteger.Type
    object InsightRuleUnboundLong extends Subtype[Long]
    type InsightRuleUnboundLong =
      zio.aws.cloudwatch.model.primitives.InsightRuleUnboundLong.Type
    object LastModified extends Subtype[Instant]
    type LastModified = zio.aws.cloudwatch.model.primitives.LastModified.Type
    object ListMetricStreamsMaxResults extends Subtype[Int]
    type ListMetricStreamsMaxResults =
      zio.aws.cloudwatch.model.primitives.ListMetricStreamsMaxResults.Type
    object MaxRecords extends Subtype[Int]
    type MaxRecords = zio.aws.cloudwatch.model.primitives.MaxRecords.Type
    object MaxReturnedResultsCount extends Subtype[Int]
    type MaxReturnedResultsCount =
      zio.aws.cloudwatch.model.primitives.MaxReturnedResultsCount.Type
    object Message extends Subtype[String]
    type Message = zio.aws.cloudwatch.model.primitives.Message.Type
    object MessageDataCode extends Subtype[String]
    type MessageDataCode =
      zio.aws.cloudwatch.model.primitives.MessageDataCode.Type
    object MessageDataValue extends Subtype[String]
    type MessageDataValue =
      zio.aws.cloudwatch.model.primitives.MessageDataValue.Type
    object MetricExpression extends Subtype[String]
    type MetricExpression =
      zio.aws.cloudwatch.model.primitives.MetricExpression.Type
    object MetricId extends Subtype[String]
    type MetricId = zio.aws.cloudwatch.model.primitives.MetricId.Type
    object MetricLabel extends Subtype[String]
    type MetricLabel = zio.aws.cloudwatch.model.primitives.MetricLabel.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.cloudwatch.model.primitives.MetricName.Type
    object MetricStreamName extends Subtype[String]
    type MetricStreamName =
      zio.aws.cloudwatch.model.primitives.MetricStreamName.Type
    object MetricStreamState extends Subtype[String]
    type MetricStreamState =
      zio.aws.cloudwatch.model.primitives.MetricStreamState.Type
    object MetricStreamStatistic extends Subtype[String]
    type MetricStreamStatistic =
      zio.aws.cloudwatch.model.primitives.MetricStreamStatistic.Type
    object MetricWidget extends Subtype[String]
    type MetricWidget = zio.aws.cloudwatch.model.primitives.MetricWidget.Type
    object MetricWidgetImage extends Subtype[Chunk[Byte]]
    type MetricWidgetImage =
      zio.aws.cloudwatch.model.primitives.MetricWidgetImage.Type
    object Namespace extends Subtype[String]
    type Namespace = zio.aws.cloudwatch.model.primitives.Namespace.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.cloudwatch.model.primitives.NextToken.Type
    object OutputFormat extends Subtype[String]
    type OutputFormat = zio.aws.cloudwatch.model.primitives.OutputFormat.Type
    object Period extends Subtype[Int]
    type Period = zio.aws.cloudwatch.model.primitives.Period.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.cloudwatch.model.primitives.ResourceName.Type
    object ReturnData extends Subtype[Boolean]
    type ReturnData = zio.aws.cloudwatch.model.primitives.ReturnData.Type
    object Size extends Subtype[Long]
    type Size = zio.aws.cloudwatch.model.primitives.Size.Type
    object Stat extends Subtype[String]
    type Stat = zio.aws.cloudwatch.model.primitives.Stat.Type
    object StateReason extends Subtype[String]
    type StateReason = zio.aws.cloudwatch.model.primitives.StateReason.Type
    object StateReasonData extends Subtype[String]
    type StateReasonData =
      zio.aws.cloudwatch.model.primitives.StateReasonData.Type
    object StorageResolution extends Subtype[Int]
    type StorageResolution =
      zio.aws.cloudwatch.model.primitives.StorageResolution.Type
    object SuppressorPeriod extends Subtype[Int]
    type SuppressorPeriod =
      zio.aws.cloudwatch.model.primitives.SuppressorPeriod.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.cloudwatch.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.cloudwatch.model.primitives.TagValue.Type
    object TemplateName extends Subtype[String]
    type TemplateName = zio.aws.cloudwatch.model.primitives.TemplateName.Type
    object Threshold extends Subtype[Double]
    type Threshold = zio.aws.cloudwatch.model.primitives.Threshold.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.cloudwatch.model.primitives.Timestamp.Type
    object TreatMissingData extends Subtype[String]
    type TreatMissingData =
      zio.aws.cloudwatch.model.primitives.TreatMissingData.Type
  }
  type AlarmHistoryItems = List[zio.aws.cloudwatch.model.AlarmHistoryItem]
  type AlarmNames = List[AlarmName]
  type AlarmTypes = List[zio.aws.cloudwatch.model.AlarmType]
  type AnomalyDetectorExcludedTimeRanges = List[zio.aws.cloudwatch.model.Range]
  type AnomalyDetectorTypes = List[zio.aws.cloudwatch.model.AnomalyDetectorType]
  type AnomalyDetectors = List[zio.aws.cloudwatch.model.AnomalyDetector]
  type BatchFailures = List[zio.aws.cloudwatch.model.PartialFailure]
  type CompositeAlarms = List[zio.aws.cloudwatch.model.CompositeAlarm]
  type Counts = List[DatapointValue]
  type DashboardEntries = List[zio.aws.cloudwatch.model.DashboardEntry]
  type DashboardNames = List[DashboardName]
  type DashboardValidationMessages =
    List[zio.aws.cloudwatch.model.DashboardValidationMessage]
  type DatapointValueMap = Map[ExtendedStatistic, DatapointValue]
  type DatapointValues = List[DatapointValue]
  type Datapoints = List[zio.aws.cloudwatch.model.Datapoint]
  type DimensionFilters = List[zio.aws.cloudwatch.model.DimensionFilter]
  type Dimensions = List[zio.aws.cloudwatch.model.Dimension]
  type ExtendedStatistics = List[ExtendedStatistic]
  type InsightRuleContributorDatapoints =
    List[zio.aws.cloudwatch.model.InsightRuleContributorDatapoint]
  type InsightRuleContributorKeyLabels = List[InsightRuleContributorKeyLabel]
  type InsightRuleContributorKeys = List[InsightRuleContributorKey]
  type InsightRuleContributors =
    List[zio.aws.cloudwatch.model.InsightRuleContributor]
  type InsightRuleMetricDatapoints =
    List[zio.aws.cloudwatch.model.InsightRuleMetricDatapoint]
  type InsightRuleMetricList = List[InsightRuleMetricName]
  type InsightRuleNames = List[InsightRuleName]
  type InsightRules = List[zio.aws.cloudwatch.model.InsightRule]
  type ManagedRuleDescriptions =
    List[zio.aws.cloudwatch.model.ManagedRuleDescription]
  type ManagedRules = List[zio.aws.cloudwatch.model.ManagedRule]
  type MetricAlarms = List[zio.aws.cloudwatch.model.MetricAlarm]
  type MetricData = List[zio.aws.cloudwatch.model.MetricDatum]
  type MetricDataQueries = List[zio.aws.cloudwatch.model.MetricDataQuery]
  type MetricDataResultMessages = List[zio.aws.cloudwatch.model.MessageData]
  type MetricDataResults = List[zio.aws.cloudwatch.model.MetricDataResult]
  type MetricStreamEntries = List[zio.aws.cloudwatch.model.MetricStreamEntry]
  type MetricStreamFilters = List[zio.aws.cloudwatch.model.MetricStreamFilter]
  type MetricStreamNames = List[MetricStreamName]
  type MetricStreamStatisticsAdditionalStatistics = List[MetricStreamStatistic]
  type MetricStreamStatisticsConfigurations =
    List[zio.aws.cloudwatch.model.MetricStreamStatisticsConfiguration]
  type MetricStreamStatisticsIncludeMetrics =
    List[zio.aws.cloudwatch.model.MetricStreamStatisticsMetric]
  type Metrics = List[zio.aws.cloudwatch.model.Metric]
  type OwningAccounts = List[AccountId]
  type ResourceList = List[ResourceName]
  type Statistics = List[zio.aws.cloudwatch.model.Statistic]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.cloudwatch.model.Tag]
  type Timestamps = List[Timestamp]
  type Values = List[DatapointValue]
}
