package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BatchGetBuildsRequest(ids: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest = {
    import BatchGetBuildsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest
      .builder()
      .ids(ids.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetBuildsRequest.ReadOnly =
    zio.aws.codebuild.model.BatchGetBuildsRequest.wrap(buildAwsValue())
}
object BatchGetBuildsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetBuildsRequest =
      zio.aws.codebuild.model.BatchGetBuildsRequest(ids)
    def ids: List[NonEmptyString]
    def getIds: ZIO[Any, Nothing, List[NonEmptyString]] = ZIO.succeed(ids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest
  ) extends zio.aws.codebuild.model.BatchGetBuildsRequest.ReadOnly {
    override val ids: List[NonEmptyString] = impl
      .ids()
      .asScala
      .map { item =>
        zio.aws.codebuild.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetBuildsRequest
  ): zio.aws.codebuild.model.BatchGetBuildsRequest.ReadOnly = new Wrapper(impl)
}
