package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class BatchGetReportsRequest(reportArns: Iterable[NonEmptyString]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest = {
    import BatchGetReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest
      .builder()
      .reportArns(reportArns.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetReportsRequest.ReadOnly =
    zio.aws.codebuild.model.BatchGetReportsRequest.wrap(buildAwsValue())
}
object BatchGetReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetReportsRequest =
      zio.aws.codebuild.model.BatchGetReportsRequest(reportArns)
    def reportArns: List[NonEmptyString]
    def getReportArns: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(reportArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest
  ) extends zio.aws.codebuild.model.BatchGetReportsRequest.ReadOnly {
    override val reportArns: List[NonEmptyString] = impl
      .reportArns()
      .asScala
      .map { item =>
        zio.aws.codebuild.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportsRequest
  ): zio.aws.codebuild.model.BatchGetReportsRequest.ReadOnly = new Wrapper(impl)
}
