package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.WrapperBoolean
import scala.jdk.CollectionConverters._
final case class BuildArtifacts(
    location: Optional[String] = Optional.Absent,
    sha256sum: Optional[String] = Optional.Absent,
    md5sum: Optional[String] = Optional.Absent,
    overrideArtifactName: Optional[WrapperBoolean] = Optional.Absent,
    encryptionDisabled: Optional[WrapperBoolean] = Optional.Absent,
    artifactIdentifier: Optional[String] = Optional.Absent,
    bucketOwnerAccess: Optional[zio.aws.codebuild.model.BucketOwnerAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildArtifacts = {
    import BuildArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildArtifacts
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(sha256sum.map(value => value: java.lang.String))(
        _.sha256sum
      )
      .optionallyWith(md5sum.map(value => value: java.lang.String))(_.md5sum)
      .optionallyWith(
        overrideArtifactName.map(value => value: java.lang.Boolean)
      )(_.overrideArtifactName)
      .optionallyWith(
        encryptionDisabled.map(value => value: java.lang.Boolean)
      )(_.encryptionDisabled)
      .optionallyWith(artifactIdentifier.map(value => value: java.lang.String))(
        _.artifactIdentifier
      )
      .optionallyWith(bucketOwnerAccess.map(value => value.unwrap))(
        _.bucketOwnerAccess
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildArtifacts.ReadOnly =
    zio.aws.codebuild.model.BuildArtifacts.wrap(buildAwsValue())
}
object BuildArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildArtifacts =
      zio.aws.codebuild.model.BuildArtifacts(
        location.map(value => value),
        sha256sum.map(value => value),
        md5sum.map(value => value),
        overrideArtifactName.map(value => value),
        encryptionDisabled.map(value => value),
        artifactIdentifier.map(value => value),
        bucketOwnerAccess.map(value => value)
      )
    def location: Optional[String]
    def sha256sum: Optional[String]
    def md5sum: Optional[String]
    def overrideArtifactName: Optional[WrapperBoolean]
    def encryptionDisabled: Optional[WrapperBoolean]
    def artifactIdentifier: Optional[String]
    def bucketOwnerAccess: Optional[zio.aws.codebuild.model.BucketOwnerAccess]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getSha256sum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sha256sum", sha256sum)
    def getMd5sum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("md5sum", md5sum)
    def getOverrideArtifactName: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("overrideArtifactName", overrideArtifactName)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getArtifactIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("artifactIdentifier", artifactIdentifier)
    def getBucketOwnerAccess
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BucketOwnerAccess] =
      AwsError.unwrapOptionField("bucketOwnerAccess", bucketOwnerAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildArtifacts
  ) extends zio.aws.codebuild.model.BuildArtifacts.ReadOnly {
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val sha256sum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sha256sum())
      .map(value => value: String)
    override val md5sum: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.md5sum())
      .map(value => value: String)
    override val overrideArtifactName: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideArtifactName())
        .map(value => value: WrapperBoolean)
    override val encryptionDisabled: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionDisabled())
        .map(value => value: WrapperBoolean)
    override val artifactIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactIdentifier())
      .map(value => value: String)
    override val bucketOwnerAccess
        : Optional[zio.aws.codebuild.model.BucketOwnerAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketOwnerAccess())
        .map(value => zio.aws.codebuild.model.BucketOwnerAccess.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildArtifacts
  ): zio.aws.codebuild.model.BuildArtifacts.ReadOnly = new Wrapper(impl)
}
