package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait BuildPhaseType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.BuildPhaseType
}
object BuildPhaseType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.BuildPhaseType
  ): zio.aws.codebuild.model.BuildPhaseType = value match {
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.DOWNLOAD_SOURCE =>
      val r = DOWNLOAD_SOURCE
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.INSTALL =>
      val r = INSTALL
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.PRE_BUILD =>
      val r = PRE_BUILD
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.BUILD =>
      val r = BUILD
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.POST_BUILD =>
      val r = POST_BUILD
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.UPLOAD_ARTIFACTS =>
      val r = UPLOAD_ARTIFACTS
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.FINALIZING =>
      val r = FINALIZING
      r
    case software.amazon.awssdk.services.codebuild.model.BuildPhaseType.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.SUBMITTED
  }
  case object QUEUED extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.QUEUED
  }
  case object PROVISIONING extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.PROVISIONING
  }
  case object DOWNLOAD_SOURCE extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.DOWNLOAD_SOURCE
  }
  case object INSTALL extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.INSTALL
  }
  case object PRE_BUILD extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.PRE_BUILD
  }
  case object BUILD extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.BUILD
  }
  case object POST_BUILD extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.POST_BUILD
  }
  case object UPLOAD_ARTIFACTS extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.UPLOAD_ARTIFACTS
  }
  case object FINALIZING extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.FINALIZING
  }
  case object COMPLETED extends zio.aws.codebuild.model.BuildPhaseType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.BuildPhaseType =
      software.amazon.awssdk.services.codebuild.model.BuildPhaseType.COMPLETED
  }
}
