package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{NonNegativeInt, Percentage}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CodeCoverageReportSummary(
    lineCoveragePercentage: Optional[Percentage] = Optional.Absent,
    linesCovered: Optional[NonNegativeInt] = Optional.Absent,
    linesMissed: Optional[NonNegativeInt] = Optional.Absent,
    branchCoveragePercentage: Optional[Percentage] = Optional.Absent,
    branchesCovered: Optional[NonNegativeInt] = Optional.Absent,
    branchesMissed: Optional[NonNegativeInt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary = {
    import CodeCoverageReportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
      .builder()
      .optionallyWith(
        lineCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.lineCoveragePercentage)
      .optionallyWith(
        linesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesCovered)
      .optionallyWith(
        linesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesMissed)
      .optionallyWith(
        branchCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.branchCoveragePercentage)
      .optionallyWith(
        branchesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesCovered)
      .optionallyWith(
        branchesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesMissed)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly =
    zio.aws.codebuild.model.CodeCoverageReportSummary.wrap(buildAwsValue())
}
object CodeCoverageReportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CodeCoverageReportSummary =
      zio.aws.codebuild.model.CodeCoverageReportSummary(
        lineCoveragePercentage.map(value => value),
        linesCovered.map(value => value),
        linesMissed.map(value => value),
        branchCoveragePercentage.map(value => value),
        branchesCovered.map(value => value),
        branchesMissed.map(value => value)
      )
    def lineCoveragePercentage: Optional[Percentage]
    def linesCovered: Optional[NonNegativeInt]
    def linesMissed: Optional[NonNegativeInt]
    def branchCoveragePercentage: Optional[Percentage]
    def branchesCovered: Optional[NonNegativeInt]
    def branchesMissed: Optional[NonNegativeInt]
    def getLineCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("lineCoveragePercentage", lineCoveragePercentage)
    def getLinesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesCovered", linesCovered)
    def getLinesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesMissed", linesMissed)
    def getBranchCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("branchCoveragePercentage", branchCoveragePercentage)
    def getBranchesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesCovered", branchesCovered)
    def getBranchesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesMissed", branchesMissed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
  ) extends zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly {
    override val lineCoveragePercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineCoveragePercentage())
        .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val linesCovered: Optional[NonNegativeInt] = zio.aws.core.internal
      .optionalFromNullable(impl.linesCovered())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val linesMissed: Optional[NonNegativeInt] = zio.aws.core.internal
      .optionalFromNullable(impl.linesMissed())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchCoveragePercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchCoveragePercentage())
        .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val branchesCovered: Optional[NonNegativeInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchesCovered())
        .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchesMissed: Optional[NonNegativeInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchesMissed())
        .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
  ): zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly = new Wrapper(
    impl
  )
}
