package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(resourceArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(NonEmptyString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteResourcePolicyRequest.wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteResourcePolicyRequest =
      zio.aws.codebuild.model.DeleteResourcePolicyRequest(resourceArn)
    def resourceArn: NonEmptyString
    def getResourceArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest
  ) extends zio.aws.codebuild.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteResourcePolicyRequest
  ): zio.aws.codebuild.model.DeleteResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
