package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyRequest(resourceArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest = {
    import GetResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest
      .builder()
      .resourceArn(NonEmptyString.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.GetResourcePolicyRequest.ReadOnly =
    zio.aws.codebuild.model.GetResourcePolicyRequest.wrap(buildAwsValue())
}
object GetResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.GetResourcePolicyRequest =
      zio.aws.codebuild.model.GetResourcePolicyRequest(resourceArn)
    def resourceArn: NonEmptyString
    def getResourceArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest
  ) extends zio.aws.codebuild.model.GetResourcePolicyRequest.ReadOnly {
    override val resourceArn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.GetResourcePolicyRequest
  ): zio.aws.codebuild.model.GetResourcePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
