package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListBuildBatchesForProjectResponse(
    ids: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse = {
    import ListBuildBatchesForProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
      .builder()
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly =
    zio.aws.codebuild.model.ListBuildBatchesForProjectResponse
      .wrap(buildAwsValue())
}
object ListBuildBatchesForProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildBatchesForProjectResponse =
      zio.aws.codebuild.model.ListBuildBatchesForProjectResponse(
        ids.map(value => value),
        nextToken.map(value => value)
      )
    def ids: Optional[List[NonEmptyString]]
    def nextToken: Optional[String]
    def getIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ids", ids)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
  ) extends zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly {
    override val ids: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildBatchesForProjectResponse
  ): zio.aws.codebuild.model.ListBuildBatchesForProjectResponse.ReadOnly =
    new Wrapper(impl)
}
