package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListProjectsResponse(
    nextToken: Optional[String] = Optional.Absent,
    projects: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListProjectsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.projects)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListProjectsResponse.ReadOnly =
    zio.aws.codebuild.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListProjectsResponse =
      zio.aws.codebuild.model.ListProjectsResponse(
        nextToken.map(value => value),
        projects.map(value => value)
      )
    def nextToken: Optional[String]
    def projects: Optional[List[NonEmptyString]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjects: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("projects", projects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListProjectsResponse
  ) extends zio.aws.codebuild.model.ListProjectsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val projects: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListProjectsResponse
  ): zio.aws.codebuild.model.ListProjectsResponse.ReadOnly = new Wrapper(impl)
}
