package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogsConfig(
    cloudWatchLogs: Optional[zio.aws.codebuild.model.CloudWatchLogsConfig] =
      Optional.Absent,
    s3Logs: Optional[zio.aws.codebuild.model.S3LogsConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.LogsConfig = {
    import LogsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.LogsConfig
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.LogsConfig.ReadOnly =
    zio.aws.codebuild.model.LogsConfig.wrap(buildAwsValue())
}
object LogsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.LogsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.LogsConfig =
      zio.aws.codebuild.model.LogsConfig(
        cloudWatchLogs.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable)
      )
    def cloudWatchLogs
        : Optional[zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly]
    def s3Logs: Optional[zio.aws.codebuild.model.S3LogsConfig.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Logs
        : ZIO[Any, AwsError, zio.aws.codebuild.model.S3LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.LogsConfig
  ) extends zio.aws.codebuild.model.LogsConfig.ReadOnly {
    override val cloudWatchLogs
        : Optional[zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogs())
        .map(value => zio.aws.codebuild.model.CloudWatchLogsConfig.wrap(value))
    override val s3Logs
        : Optional[zio.aws.codebuild.model.S3LogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Logs())
        .map(value => zio.aws.codebuild.model.S3LogsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.LogsConfig
  ): zio.aws.codebuild.model.LogsConfig.ReadOnly = new Wrapper(impl)
}
