package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class NetworkInterface(
    subnetId: Optional[NonEmptyString] = Optional.Absent,
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.NetworkInterface
      .builder()
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.NetworkInterface.ReadOnly =
    zio.aws.codebuild.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.NetworkInterface =
      zio.aws.codebuild.model.NetworkInterface(
        subnetId.map(value => value),
        networkInterfaceId.map(value => value)
      )
    def subnetId: Optional[NonEmptyString]
    def networkInterfaceId: Optional[NonEmptyString]
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.NetworkInterface
  ) extends zio.aws.codebuild.model.NetworkInterface.ReadOnly {
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.NetworkInterface
  ): zio.aws.codebuild.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
