package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ReportStatusType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ReportStatusType
}
object ReportStatusType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ReportStatusType
  ): zio.aws.codebuild.model.ReportStatusType = value match {
    case software.amazon.awssdk.services.codebuild.model.ReportStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ReportStatusType.GENERATING =>
      val r = GENERATING
      r
    case software.amazon.awssdk.services.codebuild.model.ReportStatusType.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.codebuild.model.ReportStatusType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.codebuild.model.ReportStatusType.INCOMPLETE =>
      val r = INCOMPLETE
      r
    case software.amazon.awssdk.services.codebuild.model.ReportStatusType.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object GENERATING extends zio.aws.codebuild.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportStatusType.GENERATING
  }
  case object SUCCEEDED extends zio.aws.codebuild.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportStatusType.SUCCEEDED
  }
  case object FAILED extends zio.aws.codebuild.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportStatusType.FAILED
  }
  case object INCOMPLETE extends zio.aws.codebuild.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportStatusType.INCOMPLETE
  }
  case object DELETING extends zio.aws.codebuild.model.ReportStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ReportStatusType =
      software.amazon.awssdk.services.codebuild.model.ReportStatusType.DELETING
  }
}
