package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.{WrapperBoolean, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class S3ReportExportConfig(
    bucket: Optional[NonEmptyString] = Optional.Absent,
    bucketOwner: Optional[String] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    packaging: Optional[zio.aws.codebuild.model.ReportPackagingType] =
      Optional.Absent,
    encryptionKey: Optional[NonEmptyString] = Optional.Absent,
    encryptionDisabled: Optional[WrapperBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig = {
    import S3ReportExportConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
      .builder()
      .optionallyWith(
        bucket.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(bucketOwner.map(value => value: java.lang.String))(
        _.bucketOwner
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(packaging.map(value => value.unwrap))(_.packaging)
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        encryptionDisabled.map(value => value: java.lang.Boolean)
      )(_.encryptionDisabled)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly =
    zio.aws.codebuild.model.S3ReportExportConfig.wrap(buildAwsValue())
}
object S3ReportExportConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.S3ReportExportConfig =
      zio.aws.codebuild.model.S3ReportExportConfig(
        bucket.map(value => value),
        bucketOwner.map(value => value),
        path.map(value => value),
        packaging.map(value => value),
        encryptionKey.map(value => value),
        encryptionDisabled.map(value => value)
      )
    def bucket: Optional[NonEmptyString]
    def bucketOwner: Optional[String]
    def path: Optional[String]
    def packaging: Optional[zio.aws.codebuild.model.ReportPackagingType]
    def encryptionKey: Optional[NonEmptyString]
    def encryptionDisabled: Optional[WrapperBoolean]
    def getBucket: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketOwner", bucketOwner)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getPackaging
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ReportPackagingType] =
      AwsError.unwrapOptionField("packaging", packaging)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getEncryptionDisabled: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
  ) extends zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly {
    override val bucket: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val bucketOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketOwner())
      .map(value => value: String)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val packaging
        : Optional[zio.aws.codebuild.model.ReportPackagingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packaging())
        .map(value => zio.aws.codebuild.model.ReportPackagingType.wrap(value))
    override val encryptionKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val encryptionDisabled: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionDisabled())
        .map(value => value: WrapperBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.S3ReportExportConfig
  ): zio.aws.codebuild.model.S3ReportExportConfig.ReadOnly = new Wrapper(impl)
}
