package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactPackaging {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ArtifactPackaging
}
object ArtifactPackaging {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ArtifactPackaging
  ): zio.aws.codebuild.model.ArtifactPackaging = value match {
    case software.amazon.awssdk.services.codebuild.model.ArtifactPackaging.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactPackaging.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.codebuild.model.ArtifactPackaging.ZIP =>
      val r = ZIP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.ArtifactPackaging {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactPackaging =
      software.amazon.awssdk.services.codebuild.model.ArtifactPackaging.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.codebuild.model.ArtifactPackaging {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactPackaging =
      software.amazon.awssdk.services.codebuild.model.ArtifactPackaging.NONE
  }
  case object ZIP extends zio.aws.codebuild.model.ArtifactPackaging {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ArtifactPackaging =
      software.amazon.awssdk.services.codebuild.model.ArtifactPackaging.ZIP
  }
}
