package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait AuthType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.AuthType
}
object AuthType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.AuthType
  ): zio.aws.codebuild.model.AuthType = value match {
    case software.amazon.awssdk.services.codebuild.model.AuthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.AuthType.OAUTH =>
      val r = OAUTH
      r
    case software.amazon.awssdk.services.codebuild.model.AuthType.BASIC_AUTH =>
      val r = BASIC_AUTH
      r
    case software.amazon.awssdk.services.codebuild.model.AuthType.PERSONAL_ACCESS_TOKEN =>
      val r = PERSONAL_ACCESS_TOKEN
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.AuthType =
      software.amazon.awssdk.services.codebuild.model.AuthType.UNKNOWN_TO_SDK_VERSION
  }
  case object OAUTH extends zio.aws.codebuild.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.AuthType =
      software.amazon.awssdk.services.codebuild.model.AuthType.OAUTH
  }
  case object BASIC_AUTH extends zio.aws.codebuild.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.AuthType =
      software.amazon.awssdk.services.codebuild.model.AuthType.BASIC_AUTH
  }
  case object PERSONAL_ACCESS_TOKEN extends zio.aws.codebuild.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.AuthType =
      software.amazon.awssdk.services.codebuild.model.AuthType.PERSONAL_ACCESS_TOKEN
  }
}
