package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  WrapperInt,
  Timestamp,
  WrapperLong,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Build(
    id: Optional[NonEmptyString] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    buildNumber: Optional[WrapperLong] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    currentPhase: Optional[String] = Optional.Absent,
    buildStatus: Optional[zio.aws.codebuild.model.StatusType] = Optional.Absent,
    sourceVersion: Optional[NonEmptyString] = Optional.Absent,
    resolvedSourceVersion: Optional[NonEmptyString] = Optional.Absent,
    projectName: Optional[NonEmptyString] = Optional.Absent,
    phases: Optional[Iterable[zio.aws.codebuild.model.BuildPhase]] =
      Optional.Absent,
    source: Optional[zio.aws.codebuild.model.ProjectSource] = Optional.Absent,
    secondarySources: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSource]
    ] = Optional.Absent,
    secondarySourceVersions: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = Optional.Absent,
    artifacts: Optional[zio.aws.codebuild.model.BuildArtifacts] =
      Optional.Absent,
    secondaryArtifacts: Optional[
      Iterable[zio.aws.codebuild.model.BuildArtifacts]
    ] = Optional.Absent,
    cache: Optional[zio.aws.codebuild.model.ProjectCache] = Optional.Absent,
    environment: Optional[zio.aws.codebuild.model.ProjectEnvironment] =
      Optional.Absent,
    serviceRole: Optional[NonEmptyString] = Optional.Absent,
    logs: Optional[zio.aws.codebuild.model.LogsLocation] = Optional.Absent,
    timeoutInMinutes: Optional[WrapperInt] = Optional.Absent,
    queuedTimeoutInMinutes: Optional[WrapperInt] = Optional.Absent,
    buildComplete: Optional[Boolean] = Optional.Absent,
    initiator: Optional[String] = Optional.Absent,
    vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig] = Optional.Absent,
    networkInterface: Optional[zio.aws.codebuild.model.NetworkInterface] =
      Optional.Absent,
    encryptionKey: Optional[NonEmptyString] = Optional.Absent,
    exportedEnvironmentVariables: Optional[
      Iterable[zio.aws.codebuild.model.ExportedEnvironmentVariable]
    ] = Optional.Absent,
    reportArns: Optional[Iterable[String]] = Optional.Absent,
    fileSystemLocations: Optional[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = Optional.Absent,
    debugSession: Optional[zio.aws.codebuild.model.DebugSession] =
      Optional.Absent,
    buildBatchArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.codebuild.model.Build = {
    import Build.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Build
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(buildNumber.map(value => value: java.lang.Long))(
        _.buildNumber
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(currentPhase.map(value => value: java.lang.String))(
        _.currentPhase
      )
      .optionallyWith(buildStatus.map(value => value.unwrap))(_.buildStatus)
      .optionallyWith(
        sourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceVersion)
      .optionallyWith(
        resolvedSourceVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resolvedSourceVersion)
      .optionallyWith(
        projectName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(
        phases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phases)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .optionallyWith(artifacts.map(value => value.buildAwsValue()))(
        _.artifacts
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(logs.map(value => value.buildAwsValue()))(_.logs)
      .optionallyWith(timeoutInMinutes.map(value => value: Integer))(
        _.timeoutInMinutes
      )
      .optionallyWith(queuedTimeoutInMinutes.map(value => value: Integer))(
        _.queuedTimeoutInMinutes
      )
      .optionallyWith(buildComplete.map(value => value: java.lang.Boolean))(
        _.buildComplete
      )
      .optionallyWith(initiator.map(value => value: java.lang.String))(
        _.initiator
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        exportedEnvironmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportedEnvironmentVariables)
      .optionallyWith(
        reportArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.reportArns)
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(debugSession.map(value => value.buildAwsValue()))(
        _.debugSession
      )
      .optionallyWith(buildBatchArn.map(value => value: java.lang.String))(
        _.buildBatchArn
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Build.ReadOnly =
    zio.aws.codebuild.model.Build.wrap(buildAwsValue())
}
object Build {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Build] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Build =
      zio.aws.codebuild.model.Build(
        id.map(value => value),
        arn.map(value => value),
        buildNumber.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        currentPhase.map(value => value),
        buildStatus.map(value => value),
        sourceVersion.map(value => value),
        resolvedSourceVersion.map(value => value),
        projectName.map(value => value),
        phases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source.map(value => value.asEditable),
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceRole.map(value => value),
        logs.map(value => value.asEditable),
        timeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        buildComplete.map(value => value),
        initiator.map(value => value),
        vpcConfig.map(value => value.asEditable),
        networkInterface.map(value => value.asEditable),
        encryptionKey.map(value => value),
        exportedEnvironmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reportArns.map(value => value),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        debugSession.map(value => value.asEditable),
        buildBatchArn.map(value => value)
      )
    def id: Optional[NonEmptyString]
    def arn: Optional[NonEmptyString]
    def buildNumber: Optional[WrapperLong]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def currentPhase: Optional[String]
    def buildStatus: Optional[zio.aws.codebuild.model.StatusType]
    def sourceVersion: Optional[NonEmptyString]
    def resolvedSourceVersion: Optional[NonEmptyString]
    def projectName: Optional[NonEmptyString]
    def phases: Optional[List[zio.aws.codebuild.model.BuildPhase.ReadOnly]]
    def source: Optional[zio.aws.codebuild.model.ProjectSource.ReadOnly]
    def secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def secondarySourceVersions
        : Optional[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: Optional[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]
    def secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]]
    def cache: Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment
        : Optional[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly]
    def serviceRole: Optional[NonEmptyString]
    def logs: Optional[zio.aws.codebuild.model.LogsLocation.ReadOnly]
    def timeoutInMinutes: Optional[WrapperInt]
    def queuedTimeoutInMinutes: Optional[WrapperInt]
    def buildComplete: Optional[Boolean]
    def initiator: Optional[String]
    def vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def networkInterface
        : Optional[zio.aws.codebuild.model.NetworkInterface.ReadOnly]
    def encryptionKey: Optional[NonEmptyString]
    def exportedEnvironmentVariables: Optional[
      List[zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly]
    ]
    def reportArns: Optional[List[String]]
    def fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def debugSession: Optional[zio.aws.codebuild.model.DebugSession.ReadOnly]
    def buildBatchArn: Optional[String]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getBuildNumber: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("buildNumber", buildNumber)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCurrentPhase: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentPhase", currentPhase)
    def getBuildStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("buildStatus", buildStatus)
    def getSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getResolvedSourceVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resolvedSourceVersion", resolvedSourceVersion)
    def getProjectName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getPhases: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildPhase.ReadOnly
    ]] = AwsError.unwrapOptionField("phases", phases)
    def getSource
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildArtifacts.ReadOnly] =
      AwsError.unwrapOptionField("artifacts", artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.BuildArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getLogs
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsLocation.ReadOnly] =
      AwsError.unwrapOptionField("logs", logs)
    def getTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, WrapperInt] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getBuildComplete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("buildComplete", buildComplete)
    def getInitiator: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getNetworkInterface: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.NetworkInterface.ReadOnly
    ] = AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getExportedEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "exportedEnvironmentVariables",
      exportedEnvironmentVariables
    )
    def getReportArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("reportArns", reportArns)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getDebugSession
        : ZIO[Any, AwsError, zio.aws.codebuild.model.DebugSession.ReadOnly] =
      AwsError.unwrapOptionField("debugSession", debugSession)
    def getBuildBatchArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("buildBatchArn", buildBatchArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Build
  ) extends zio.aws.codebuild.model.Build.ReadOnly {
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val buildNumber: Optional[WrapperLong] = zio.aws.core.internal
      .optionalFromNullable(impl.buildNumber())
      .map(value => value: WrapperLong)
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val currentPhase: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentPhase())
      .map(value => value: String)
    override val buildStatus: Optional[zio.aws.codebuild.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildStatus())
        .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val sourceVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val resolvedSourceVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedSourceVersion())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val projectName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val phases
        : Optional[List[zio.aws.codebuild.model.BuildPhase.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildPhase.wrap(item)
          }.toList
        )
    override val source
        : Optional[zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.codebuild.model.ProjectSource.wrap(value))
    override val secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondarySources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSource.wrap(item)
          }.toList
        )
    override val secondarySourceVersions: Optional[
      List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondarySourceVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
        }.toList
      )
    override val artifacts
        : Optional[zio.aws.codebuild.model.BuildArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifacts())
        .map(value => zio.aws.codebuild.model.BuildArtifacts.wrap(value))
    override val secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.BuildArtifacts.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.BuildArtifacts.wrap(item)
          }.toList
        )
    override val cache
        : Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : Optional[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.codebuild.model.ProjectEnvironment.wrap(value))
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val logs: Optional[zio.aws.codebuild.model.LogsLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logs())
        .map(value => zio.aws.codebuild.model.LogsLocation.wrap(value))
    override val timeoutInMinutes: Optional[WrapperInt] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMinutes())
      .map(value => value: WrapperInt)
    override val queuedTimeoutInMinutes: Optional[WrapperInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuedTimeoutInMinutes())
        .map(value => value: WrapperInt)
    override val buildComplete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.buildComplete())
      .map(value => value: Boolean)
    override val initiator: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.initiator())
      .map(value => value: String)
    override val vpcConfig
        : Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val networkInterface
        : Optional[zio.aws.codebuild.model.NetworkInterface.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterface())
        .map(value => zio.aws.codebuild.model.NetworkInterface.wrap(value))
    override val encryptionKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val exportedEnvironmentVariables: Optional[
      List[zio.aws.codebuild.model.ExportedEnvironmentVariable.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportedEnvironmentVariables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ExportedEnvironmentVariable.wrap(item)
        }.toList
      )
    override val reportArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.reportArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val debugSession
        : Optional[zio.aws.codebuild.model.DebugSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.debugSession())
        .map(value => zio.aws.codebuild.model.DebugSession.wrap(value))
    override val buildBatchArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.buildBatchArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Build
  ): zio.aws.codebuild.model.Build.ReadOnly = new Wrapper(impl)
}
