package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait CacheType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.CacheType
}
object CacheType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.CacheType
  ): zio.aws.codebuild.model.CacheType = value match {
    case software.amazon.awssdk.services.codebuild.model.CacheType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.CacheType.NO_CACHE =>
      val r = NO_CACHE
      r
    case software.amazon.awssdk.services.codebuild.model.CacheType.S3 =>
      val r = S3
      r
    case software.amazon.awssdk.services.codebuild.model.CacheType.LOCAL =>
      val r = LOCAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.CacheType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheType =
      software.amazon.awssdk.services.codebuild.model.CacheType.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_CACHE extends zio.aws.codebuild.model.CacheType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheType =
      software.amazon.awssdk.services.codebuild.model.CacheType.NO_CACHE
  }
  case object S3 extends zio.aws.codebuild.model.CacheType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheType =
      software.amazon.awssdk.services.codebuild.model.CacheType.S3
  }
  case object LOCAL extends zio.aws.codebuild.model.CacheType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.CacheType =
      software.amazon.awssdk.services.codebuild.model.CacheType.LOCAL
  }
}
