package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.ProjectName
import scala.jdk.CollectionConverters._
final case class DeleteWebhookRequest(projectName: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest = {
    import DeleteWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest
      .builder()
      .projectName(ProjectName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DeleteWebhookRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteWebhookRequest.wrap(buildAwsValue())
}
object DeleteWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteWebhookRequest =
      zio.aws.codebuild.model.DeleteWebhookRequest(projectName)
    def projectName: ProjectName
    def getProjectName: ZIO[Any, Nothing, ProjectName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest
  ) extends zio.aws.codebuild.model.DeleteWebhookRequest.ReadOnly {
    override val projectName: ProjectName =
      zio.aws.codebuild.model.primitives.ProjectName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteWebhookRequest
  ): zio.aws.codebuild.model.DeleteWebhookRequest.ReadOnly = new Wrapper(impl)
}
