package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetReportGroupTrendResponse(
    stats: Optional[zio.aws.codebuild.model.ReportGroupTrendStats] =
      Optional.Absent,
    rawData: Optional[Iterable[zio.aws.codebuild.model.ReportWithRawData]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse = {
    import GetReportGroupTrendResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse
      .builder()
      .optionallyWith(stats.map(value => value.buildAwsValue()))(_.stats)
      .optionallyWith(
        rawData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rawData)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly =
    zio.aws.codebuild.model.GetReportGroupTrendResponse.wrap(buildAwsValue())
}
object GetReportGroupTrendResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.GetReportGroupTrendResponse =
      zio.aws.codebuild.model.GetReportGroupTrendResponse(
        stats.map(value => value.asEditable),
        rawData.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stats: Optional[zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly]
    def rawData
        : Optional[List[zio.aws.codebuild.model.ReportWithRawData.ReadOnly]]
    def getStats: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly
    ] = AwsError.unwrapOptionField("stats", stats)
    def getRawData: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ReportWithRawData.ReadOnly
    ]] = AwsError.unwrapOptionField("rawData", rawData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse
  ) extends zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly {
    override val stats
        : Optional[zio.aws.codebuild.model.ReportGroupTrendStats.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stats())
        .map(value => zio.aws.codebuild.model.ReportGroupTrendStats.wrap(value))
    override val rawData
        : Optional[List[zio.aws.codebuild.model.ReportWithRawData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rawData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ReportWithRawData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.GetReportGroupTrendResponse
  ): zio.aws.codebuild.model.GetReportGroupTrendResponse.ReadOnly = new Wrapper(
    impl
  )
}
