package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.{
  WrapperBoolean,
  SensitiveNonEmptyString,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class ImportSourceCredentialsRequest(
    username: Optional[NonEmptyString] = Optional.Absent,
    token: SensitiveNonEmptyString,
    serverType: zio.aws.codebuild.model.ServerType,
    authType: zio.aws.codebuild.model.AuthType,
    shouldOverwrite: Optional[WrapperBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest = {
    import ImportSourceCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest
      .builder()
      .optionallyWith(
        username.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.username)
      .token(SensitiveNonEmptyString.unwrap(token): java.lang.String)
      .serverType(serverType.unwrap)
      .authType(authType.unwrap)
      .optionallyWith(shouldOverwrite.map(value => value: java.lang.Boolean))(
        _.shouldOverwrite
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.ImportSourceCredentialsRequest.ReadOnly =
    zio.aws.codebuild.model.ImportSourceCredentialsRequest.wrap(buildAwsValue())
}
object ImportSourceCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ImportSourceCredentialsRequest =
      zio.aws.codebuild.model.ImportSourceCredentialsRequest(
        username.map(value => value),
        token,
        serverType,
        authType,
        shouldOverwrite.map(value => value)
      )
    def username: Optional[NonEmptyString]
    def token: SensitiveNonEmptyString
    def serverType: zio.aws.codebuild.model.ServerType
    def authType: zio.aws.codebuild.model.AuthType
    def shouldOverwrite: Optional[WrapperBoolean]
    def getUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("username", username)
    def getToken: ZIO[Any, Nothing, SensitiveNonEmptyString] =
      ZIO.succeed(token)
    def getServerType: ZIO[Any, Nothing, zio.aws.codebuild.model.ServerType] =
      ZIO.succeed(serverType)
    def getAuthType: ZIO[Any, Nothing, zio.aws.codebuild.model.AuthType] =
      ZIO.succeed(authType)
    def getShouldOverwrite: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("shouldOverwrite", shouldOverwrite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest
  ) extends zio.aws.codebuild.model.ImportSourceCredentialsRequest.ReadOnly {
    override val username: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val token: SensitiveNonEmptyString =
      zio.aws.codebuild.model.primitives.SensitiveNonEmptyString(impl.token())
    override val serverType: zio.aws.codebuild.model.ServerType =
      zio.aws.codebuild.model.ServerType.wrap(impl.serverType())
    override val authType: zio.aws.codebuild.model.AuthType =
      zio.aws.codebuild.model.AuthType.wrap(impl.authType())
    override val shouldOverwrite: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shouldOverwrite())
        .map(value => value: WrapperBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ImportSourceCredentialsRequest
  ): zio.aws.codebuild.model.ImportSourceCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
