package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class ListBuildsForProjectRequest(
    projectName: NonEmptyString,
    sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest = {
    import ListBuildsForProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
      .builder()
      .projectName(NonEmptyString.unwrap(projectName): java.lang.String)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ListBuildsForProjectRequest.ReadOnly =
    zio.aws.codebuild.model.ListBuildsForProjectRequest.wrap(buildAwsValue())
}
object ListBuildsForProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ListBuildsForProjectRequest =
      zio.aws.codebuild.model.ListBuildsForProjectRequest(
        projectName,
        sortOrder.map(value => value),
        nextToken.map(value => value)
      )
    def projectName: NonEmptyString
    def sortOrder: Optional[zio.aws.codebuild.model.SortOrderType]
    def nextToken: Optional[String]
    def getProjectName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(projectName)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.codebuild.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
  ) extends zio.aws.codebuild.model.ListBuildsForProjectRequest.ReadOnly {
    override val projectName: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.projectName())
    override val sortOrder: Optional[zio.aws.codebuild.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codebuild.model.SortOrderType.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ListBuildsForProjectRequest
  ): zio.aws.codebuild.model.ListBuildsForProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
