package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait LogsConfigStatusType {
  def unwrap
      : software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType
}
object LogsConfigStatusType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType
  ): zio.aws.codebuild.model.LogsConfigStatusType = value match {
    case software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codebuild.model.LogsConfigStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType =
      software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.codebuild.model.LogsConfigStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType =
      software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType.ENABLED
  }
  case object DISABLED extends zio.aws.codebuild.model.LogsConfigStatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType =
      software.amazon.awssdk.services.codebuild.model.LogsConfigStatusType.DISABLED
  }
}
