package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LogsLocation(
    groupName: Optional[String] = Optional.Absent,
    streamName: Optional[String] = Optional.Absent,
    deepLink: Optional[String] = Optional.Absent,
    s3DeepLink: Optional[String] = Optional.Absent,
    cloudWatchLogsArn: Optional[String] = Optional.Absent,
    s3LogsArn: Optional[String] = Optional.Absent,
    cloudWatchLogs: Optional[zio.aws.codebuild.model.CloudWatchLogsConfig] =
      Optional.Absent,
    s3Logs: Optional[zio.aws.codebuild.model.S3LogsConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.LogsLocation = {
    import LogsLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.LogsLocation
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(streamName.map(value => value: java.lang.String))(
        _.streamName
      )
      .optionallyWith(deepLink.map(value => value: java.lang.String))(
        _.deepLink
      )
      .optionallyWith(s3DeepLink.map(value => value: java.lang.String))(
        _.s3DeepLink
      )
      .optionallyWith(cloudWatchLogsArn.map(value => value: java.lang.String))(
        _.cloudWatchLogsArn
      )
      .optionallyWith(s3LogsArn.map(value => value: java.lang.String))(
        _.s3LogsArn
      )
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.LogsLocation.ReadOnly =
    zio.aws.codebuild.model.LogsLocation.wrap(buildAwsValue())
}
object LogsLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.LogsLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.LogsLocation =
      zio.aws.codebuild.model.LogsLocation(
        groupName.map(value => value),
        streamName.map(value => value),
        deepLink.map(value => value),
        s3DeepLink.map(value => value),
        cloudWatchLogsArn.map(value => value),
        s3LogsArn.map(value => value),
        cloudWatchLogs.map(value => value.asEditable),
        s3Logs.map(value => value.asEditable)
      )
    def groupName: Optional[String]
    def streamName: Optional[String]
    def deepLink: Optional[String]
    def s3DeepLink: Optional[String]
    def cloudWatchLogsArn: Optional[String]
    def s3LogsArn: Optional[String]
    def cloudWatchLogs
        : Optional[zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly]
    def s3Logs: Optional[zio.aws.codebuild.model.S3LogsConfig.ReadOnly]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getDeepLink: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deepLink", deepLink)
    def getS3DeepLink: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3DeepLink", s3DeepLink)
    def getCloudWatchLogsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudWatchLogsArn", cloudWatchLogsArn)
    def getS3LogsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3LogsArn", s3LogsArn)
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getS3Logs
        : ZIO[Any, AwsError, zio.aws.codebuild.model.S3LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.LogsLocation
  ) extends zio.aws.codebuild.model.LogsLocation.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val streamName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => value: String)
    override val deepLink: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deepLink())
      .map(value => value: String)
    override val s3DeepLink: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3DeepLink())
      .map(value => value: String)
    override val cloudWatchLogsArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsArn())
      .map(value => value: String)
    override val s3LogsArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3LogsArn())
      .map(value => value: String)
    override val cloudWatchLogs
        : Optional[zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogs())
        .map(value => zio.aws.codebuild.model.CloudWatchLogsConfig.wrap(value))
    override val s3Logs
        : Optional[zio.aws.codebuild.model.S3LogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Logs())
        .map(value => zio.aws.codebuild.model.S3LogsConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.LogsLocation
  ): zio.aws.codebuild.model.LogsLocation.ReadOnly = new Wrapper(impl)
}
