package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  ProjectName,
  Timestamp,
  ProjectDescription,
  WrapperInt,
  TimeOut,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Project(
    name: Optional[ProjectName] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    description: Optional[ProjectDescription] = Optional.Absent,
    source: Optional[zio.aws.codebuild.model.ProjectSource] = Optional.Absent,
    secondarySources: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSource]
    ] = Optional.Absent,
    sourceVersion: Optional[String] = Optional.Absent,
    secondarySourceVersions: Optional[
      Iterable[zio.aws.codebuild.model.ProjectSourceVersion]
    ] = Optional.Absent,
    artifacts: Optional[zio.aws.codebuild.model.ProjectArtifacts] =
      Optional.Absent,
    secondaryArtifacts: Optional[
      Iterable[zio.aws.codebuild.model.ProjectArtifacts]
    ] = Optional.Absent,
    cache: Optional[zio.aws.codebuild.model.ProjectCache] = Optional.Absent,
    environment: Optional[zio.aws.codebuild.model.ProjectEnvironment] =
      Optional.Absent,
    serviceRole: Optional[NonEmptyString] = Optional.Absent,
    timeoutInMinutes: Optional[TimeOut] = Optional.Absent,
    queuedTimeoutInMinutes: Optional[TimeOut] = Optional.Absent,
    encryptionKey: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codebuild.model.Tag]] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    lastModified: Optional[Timestamp] = Optional.Absent,
    webhook: Optional[zio.aws.codebuild.model.Webhook] = Optional.Absent,
    vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig] = Optional.Absent,
    badge: Optional[zio.aws.codebuild.model.ProjectBadge] = Optional.Absent,
    logsConfig: Optional[zio.aws.codebuild.model.LogsConfig] = Optional.Absent,
    fileSystemLocations: Optional[
      Iterable[zio.aws.codebuild.model.ProjectFileSystemLocation]
    ] = Optional.Absent,
    buildBatchConfig: Optional[
      zio.aws.codebuild.model.ProjectBuildBatchConfig
    ] = Optional.Absent,
    concurrentBuildLimit: Optional[WrapperInt] = Optional.Absent,
    projectVisibility: Optional[zio.aws.codebuild.model.ProjectVisibilityType] =
      Optional.Absent,
    publicProjectAlias: Optional[NonEmptyString] = Optional.Absent,
    resourceAccessRole: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.Project = {
    import Project.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.Project
      .builder()
      .optionallyWith(
        name.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        secondarySources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySources)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondarySourceVersions)
      .optionallyWith(artifacts.map(value => value.buildAwsValue()))(
        _.artifacts
      )
      .optionallyWith(
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryArtifacts)
      .optionallyWith(cache.map(value => value.buildAwsValue()))(_.cache)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeOut.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        queuedTimeoutInMinutes.map(value => TimeOut.unwrap(value): Integer)
      )(_.queuedTimeoutInMinutes)
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        lastModified.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(webhook.map(value => value.buildAwsValue()))(_.webhook)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(badge.map(value => value.buildAwsValue()))(_.badge)
      .optionallyWith(logsConfig.map(value => value.buildAwsValue()))(
        _.logsConfig
      )
      .optionallyWith(
        fileSystemLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystemLocations)
      .optionallyWith(buildBatchConfig.map(value => value.buildAwsValue()))(
        _.buildBatchConfig
      )
      .optionallyWith(concurrentBuildLimit.map(value => value: Integer))(
        _.concurrentBuildLimit
      )
      .optionallyWith(projectVisibility.map(value => value.unwrap))(
        _.projectVisibility
      )
      .optionallyWith(
        publicProjectAlias.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicProjectAlias)
      .optionallyWith(
        resourceAccessRole.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceAccessRole)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.Project.ReadOnly =
    zio.aws.codebuild.model.Project.wrap(buildAwsValue())
}
object Project {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codebuild.model.Project] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.Project =
      zio.aws.codebuild.model.Project(
        name.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        source.map(value => value.asEditable),
        secondarySources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceVersion.map(value => value),
        secondarySourceVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifacts.map(value => value.asEditable),
        secondaryArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cache.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        serviceRole.map(value => value),
        timeoutInMinutes.map(value => value),
        queuedTimeoutInMinutes.map(value => value),
        encryptionKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        created.map(value => value),
        lastModified.map(value => value),
        webhook.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        badge.map(value => value.asEditable),
        logsConfig.map(value => value.asEditable),
        fileSystemLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildBatchConfig.map(value => value.asEditable),
        concurrentBuildLimit.map(value => value),
        projectVisibility.map(value => value),
        publicProjectAlias.map(value => value),
        resourceAccessRole.map(value => value)
      )
    def name: Optional[ProjectName]
    def arn: Optional[String]
    def description: Optional[ProjectDescription]
    def source: Optional[zio.aws.codebuild.model.ProjectSource.ReadOnly]
    def secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]]
    def sourceVersion: Optional[String]
    def secondarySourceVersions
        : Optional[List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]]
    def artifacts: Optional[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]
    def secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]]
    def cache: Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly]
    def environment
        : Optional[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly]
    def serviceRole: Optional[NonEmptyString]
    def timeoutInMinutes: Optional[TimeOut]
    def queuedTimeoutInMinutes: Optional[TimeOut]
    def encryptionKey: Optional[NonEmptyString]
    def tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]]
    def created: Optional[Timestamp]
    def lastModified: Optional[Timestamp]
    def webhook: Optional[zio.aws.codebuild.model.Webhook.ReadOnly]
    def vpcConfig: Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly]
    def badge: Optional[zio.aws.codebuild.model.ProjectBadge.ReadOnly]
    def logsConfig: Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly]
    def fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ]
    def buildBatchConfig
        : Optional[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly]
    def concurrentBuildLimit: Optional[WrapperInt]
    def projectVisibility
        : Optional[zio.aws.codebuild.model.ProjectVisibilityType]
    def publicProjectAlias: Optional[NonEmptyString]
    def resourceAccessRole: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSource
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getSecondarySources: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSource.ReadOnly
    ]] = AwsError.unwrapOptionField("secondarySources", secondarySources)
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getSecondarySourceVersions: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondarySourceVersions",
      secondarySourceVersions
    )
    def getArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getSecondaryArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectArtifacts.ReadOnly
    ]] = AwsError.unwrapOptionField("secondaryArtifacts", secondaryArtifacts)
    def getCache
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      AwsError.unwrapOptionField("cache", cache)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeOut] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getQueuedTimeoutInMinutes: ZIO[Any, AwsError, TimeOut] = AwsError
      .unwrapOptionField("queuedTimeoutInMinutes", queuedTimeoutInMinutes)
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getLastModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getWebhook
        : ZIO[Any, AwsError, zio.aws.codebuild.model.Webhook.ReadOnly] =
      AwsError.unwrapOptionField("webhook", webhook)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getBadge
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectBadge.ReadOnly] =
      AwsError.unwrapOptionField("badge", badge)
    def getLogsConfig
        : ZIO[Any, AwsError, zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      AwsError.unwrapOptionField("logsConfig", logsConfig)
    def getFileSystemLocations: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly
    ]] = AwsError.unwrapOptionField("fileSystemLocations", fileSystemLocations)
    def getBuildBatchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly
    ] = AwsError.unwrapOptionField("buildBatchConfig", buildBatchConfig)
    def getConcurrentBuildLimit: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("concurrentBuildLimit", concurrentBuildLimit)
    def getProjectVisibility
        : ZIO[Any, AwsError, zio.aws.codebuild.model.ProjectVisibilityType] =
      AwsError.unwrapOptionField("projectVisibility", projectVisibility)
    def getPublicProjectAlias: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicProjectAlias", publicProjectAlias)
    def getResourceAccessRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceAccessRole", resourceAccessRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.Project
  ) extends zio.aws.codebuild.model.Project.ReadOnly {
    override val name: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codebuild.model.primitives.ProjectName(value))
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val description: Optional[ProjectDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codebuild.model.primitives.ProjectDescription(value)
        )
    override val source
        : Optional[zio.aws.codebuild.model.ProjectSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.codebuild.model.ProjectSource.wrap(value))
    override val secondarySources
        : Optional[List[zio.aws.codebuild.model.ProjectSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondarySources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectSource.wrap(item)
          }.toList
        )
    override val sourceVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceVersion())
      .map(value => value: String)
    override val secondarySourceVersions: Optional[
      List[zio.aws.codebuild.model.ProjectSourceVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondarySourceVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectSourceVersion.wrap(item)
        }.toList
      )
    override val artifacts
        : Optional[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifacts())
        .map(value => zio.aws.codebuild.model.ProjectArtifacts.wrap(value))
    override val secondaryArtifacts
        : Optional[List[zio.aws.codebuild.model.ProjectArtifacts.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.ProjectArtifacts.wrap(item)
          }.toList
        )
    override val cache
        : Optional[zio.aws.codebuild.model.ProjectCache.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cache())
        .map(value => zio.aws.codebuild.model.ProjectCache.wrap(value))
    override val environment
        : Optional[zio.aws.codebuild.model.ProjectEnvironment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.codebuild.model.ProjectEnvironment.wrap(value))
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val timeoutInMinutes: Optional[TimeOut] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMinutes())
      .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val queuedTimeoutInMinutes: Optional[TimeOut] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queuedTimeoutInMinutes())
        .map(value => zio.aws.codebuild.model.primitives.TimeOut(value))
    override val encryptionKey: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val tags: Optional[List[zio.aws.codebuild.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codebuild.model.Tag.wrap(item)
          }.toList
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val lastModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val webhook: Optional[zio.aws.codebuild.model.Webhook.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webhook())
        .map(value => zio.aws.codebuild.model.Webhook.wrap(value))
    override val vpcConfig
        : Optional[zio.aws.codebuild.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.codebuild.model.VpcConfig.wrap(value))
    override val badge
        : Optional[zio.aws.codebuild.model.ProjectBadge.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.badge())
        .map(value => zio.aws.codebuild.model.ProjectBadge.wrap(value))
    override val logsConfig
        : Optional[zio.aws.codebuild.model.LogsConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logsConfig())
        .map(value => zio.aws.codebuild.model.LogsConfig.wrap(value))
    override val fileSystemLocations: Optional[
      List[zio.aws.codebuild.model.ProjectFileSystemLocation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemLocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.ProjectFileSystemLocation.wrap(item)
        }.toList
      )
    override val buildBatchConfig
        : Optional[zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatchConfig())
        .map(value =>
          zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(value)
        )
    override val concurrentBuildLimit: Optional[WrapperInt] =
      zio.aws.core.internal
        .optionalFromNullable(impl.concurrentBuildLimit())
        .map(value => value: WrapperInt)
    override val projectVisibility
        : Optional[zio.aws.codebuild.model.ProjectVisibilityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projectVisibility())
        .map(value => zio.aws.codebuild.model.ProjectVisibilityType.wrap(value))
    override val publicProjectAlias: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicProjectAlias())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val resourceAccessRole: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceAccessRole())
        .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.Project
  ): zio.aws.codebuild.model.Project.ReadOnly = new Wrapper(impl)
}
