package zio.aws.codebuild.model
import zio.aws.codebuild.model.primitives.{
  WrapperInt,
  WrapperBoolean,
  NonEmptyString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProjectBuildBatchConfig(
    serviceRole: Optional[NonEmptyString] = Optional.Absent,
    combineArtifacts: Optional[WrapperBoolean] = Optional.Absent,
    restrictions: Optional[zio.aws.codebuild.model.BatchRestrictions] =
      Optional.Absent,
    timeoutInMins: Optional[WrapperInt] = Optional.Absent,
    batchReportMode: Optional[zio.aws.codebuild.model.BatchReportModeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig = {
    import ProjectBuildBatchConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig
      .builder()
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(combineArtifacts.map(value => value: java.lang.Boolean))(
        _.combineArtifacts
      )
      .optionallyWith(restrictions.map(value => value.buildAwsValue()))(
        _.restrictions
      )
      .optionallyWith(timeoutInMins.map(value => value: Integer))(
        _.timeoutInMins
      )
      .optionallyWith(batchReportMode.map(value => value.unwrap))(
        _.batchReportMode
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly =
    zio.aws.codebuild.model.ProjectBuildBatchConfig.wrap(buildAwsValue())
}
object ProjectBuildBatchConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.ProjectBuildBatchConfig =
      zio.aws.codebuild.model.ProjectBuildBatchConfig(
        serviceRole.map(value => value),
        combineArtifacts.map(value => value),
        restrictions.map(value => value.asEditable),
        timeoutInMins.map(value => value),
        batchReportMode.map(value => value)
      )
    def serviceRole: Optional[NonEmptyString]
    def combineArtifacts: Optional[WrapperBoolean]
    def restrictions
        : Optional[zio.aws.codebuild.model.BatchRestrictions.ReadOnly]
    def timeoutInMins: Optional[WrapperInt]
    def batchReportMode: Optional[zio.aws.codebuild.model.BatchReportModeType]
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getCombineArtifacts: ZIO[Any, AwsError, WrapperBoolean] =
      AwsError.unwrapOptionField("combineArtifacts", combineArtifacts)
    def getRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.codebuild.model.BatchRestrictions.ReadOnly
    ] = AwsError.unwrapOptionField("restrictions", restrictions)
    def getTimeoutInMins: ZIO[Any, AwsError, WrapperInt] =
      AwsError.unwrapOptionField("timeoutInMins", timeoutInMins)
    def getBatchReportMode
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BatchReportModeType] =
      AwsError.unwrapOptionField("batchReportMode", batchReportMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig
  ) extends zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly {
    override val serviceRole: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.codebuild.model.primitives.NonEmptyString(value))
    override val combineArtifacts: Optional[WrapperBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.combineArtifacts())
        .map(value => value: WrapperBoolean)
    override val restrictions
        : Optional[zio.aws.codebuild.model.BatchRestrictions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restrictions())
        .map(value => zio.aws.codebuild.model.BatchRestrictions.wrap(value))
    override val timeoutInMins: Optional[WrapperInt] = zio.aws.core.internal
      .optionalFromNullable(impl.timeoutInMins())
      .map(value => value: WrapperInt)
    override val batchReportMode
        : Optional[zio.aws.codebuild.model.BatchReportModeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchReportMode())
        .map(value => zio.aws.codebuild.model.BatchReportModeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig
  ): zio.aws.codebuild.model.ProjectBuildBatchConfig.ReadOnly = new Wrapper(
    impl
  )
}
