package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RetryBuildBatchResponse(
    buildBatch: Optional[zio.aws.codebuild.model.BuildBatch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse = {
    import RetryBuildBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse
      .builder()
      .optionallyWith(buildBatch.map(value => value.buildAwsValue()))(
        _.buildBatch
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly =
    zio.aws.codebuild.model.RetryBuildBatchResponse.wrap(buildAwsValue())
}
object RetryBuildBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.RetryBuildBatchResponse =
      zio.aws.codebuild.model
        .RetryBuildBatchResponse(buildBatch.map(value => value.asEditable))
    def buildBatch: Optional[zio.aws.codebuild.model.BuildBatch.ReadOnly]
    def getBuildBatch
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildBatch.ReadOnly] =
      AwsError.unwrapOptionField("buildBatch", buildBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse
  ) extends zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly {
    override val buildBatch
        : Optional[zio.aws.codebuild.model.BuildBatch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildBatch())
        .map(value => zio.aws.codebuild.model.BuildBatch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.RetryBuildBatchResponse
  ): zio.aws.codebuild.model.RetryBuildBatchResponse.ReadOnly = new Wrapper(
    impl
  )
}
