package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait ServerType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.ServerType
}
object ServerType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.ServerType
  ): zio.aws.codebuild.model.ServerType = value match {
    case software.amazon.awssdk.services.codebuild.model.ServerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.ServerType.GITHUB =>
      val r = GITHUB
      r
    case software.amazon.awssdk.services.codebuild.model.ServerType.BITBUCKET =>
      val r = BITBUCKET
      r
    case software.amazon.awssdk.services.codebuild.model.ServerType.GITHUB_ENTERPRISE =>
      val r = GITHUB_ENTERPRISE
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.ServerType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ServerType =
      software.amazon.awssdk.services.codebuild.model.ServerType.UNKNOWN_TO_SDK_VERSION
  }
  case object GITHUB extends zio.aws.codebuild.model.ServerType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ServerType =
      software.amazon.awssdk.services.codebuild.model.ServerType.GITHUB
  }
  case object BITBUCKET extends zio.aws.codebuild.model.ServerType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ServerType =
      software.amazon.awssdk.services.codebuild.model.ServerType.BITBUCKET
  }
  case object GITHUB_ENTERPRISE extends zio.aws.codebuild.model.ServerType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.ServerType =
      software.amazon.awssdk.services.codebuild.model.ServerType.GITHUB_ENTERPRISE
  }
}
