package zio.aws.codebuild.model
import scala.jdk.CollectionConverters._
sealed trait StatusType {
  def unwrap: software.amazon.awssdk.services.codebuild.model.StatusType
}
object StatusType {
  def wrap(
      value: software.amazon.awssdk.services.codebuild.model.StatusType
  ): zio.aws.codebuild.model.StatusType = value match {
    case software.amazon.awssdk.services.codebuild.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codebuild.model.StatusType.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.codebuild.model.StatusType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.codebuild.model.StatusType.FAULT =>
      val r = FAULT
      r
    case software.amazon.awssdk.services.codebuild.model.StatusType.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.codebuild.model.StatusType.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.codebuild.model.StatusType.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.SUCCEEDED
  }
  case object FAILED extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.FAILED
  }
  case object FAULT extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.FAULT
  }
  case object TIMED_OUT extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.TIMED_OUT
  }
  case object IN_PROGRESS extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.IN_PROGRESS
  }
  case object STOPPED extends zio.aws.codebuild.model.StatusType {
    override def unwrap
        : software.amazon.awssdk.services.codebuild.model.StatusType =
      software.amazon.awssdk.services.codebuild.model.StatusType.STOPPED
  }
}
