package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class StopBuildBatchRequest(id: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest = {
    import StopBuildBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.StopBuildBatchRequest.ReadOnly =
    zio.aws.codebuild.model.StopBuildBatchRequest.wrap(buildAwsValue())
}
object StopBuildBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.StopBuildBatchRequest =
      zio.aws.codebuild.model.StopBuildBatchRequest(id)
    def id: NonEmptyString
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest
  ) extends zio.aws.codebuild.model.StopBuildBatchRequest.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.StopBuildBatchRequest
  ): zio.aws.codebuild.model.StopBuildBatchRequest.ReadOnly = new Wrapper(impl)
}
