package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class BatchGetReportGroupsRequest(
    reportGroupArns: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest = {
    import BatchGetReportGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest
      .builder()
      .reportGroupArns(reportGroupArns.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetReportGroupsRequest.ReadOnly =
    zio.aws.codebuild.model.BatchGetReportGroupsRequest.wrap(buildAwsValue())
}
object BatchGetReportGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetReportGroupsRequest =
      zio.aws.codebuild.model.BatchGetReportGroupsRequest(reportGroupArns)
    def reportGroupArns: List[NonEmptyString]
    def getReportGroupArns: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(reportGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest
  ) extends zio.aws.codebuild.model.BatchGetReportGroupsRequest.ReadOnly {
    override val reportGroupArns: List[NonEmptyString] = impl
      .reportGroupArns()
      .asScala
      .map { item =>
        zio.aws.codebuild.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportGroupsRequest
  ): zio.aws.codebuild.model.BatchGetReportGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
