package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class BatchGetReportsResponse(
    reports: Option[Iterable[zio.aws.codebuild.model.Report]] = None,
    reportsNotFound: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse = {
    import BatchGetReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse
      .builder()
      .optionallyWith(
        reports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reports)
      .optionallyWith(
        reportsNotFound.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reportsNotFound)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly =
    zio.aws.codebuild.model.BatchGetReportsResponse.wrap(buildAwsValue())
}
object BatchGetReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BatchGetReportsResponse =
      zio.aws.codebuild.model.BatchGetReportsResponse(
        reports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reportsNotFound.map(value => value)
      )
    def reports: Option[List[zio.aws.codebuild.model.Report.ReadOnly]]
    def reportsNotFound: Option[List[NonEmptyString]]
    def getReports
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.Report.ReadOnly]] =
      AwsError.unwrapOptionField("reports", reports)
    def getReportsNotFound: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("reportsNotFound", reportsNotFound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse
  ) extends zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly {
    override val reports
        : Option[List[zio.aws.codebuild.model.Report.ReadOnly]] = scala
      .Option(impl.reports())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.Report.wrap(item)
        }.toList
      )
    override val reportsNotFound: Option[List[NonEmptyString]] = scala
      .Option(impl.reportsNotFound())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BatchGetReportsResponse
  ): zio.aws.codebuild.model.BatchGetReportsResponse.ReadOnly = new Wrapper(
    impl
  )
}
