package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codebuild.model.primitives.{WrapperLong, Timestamp}
import scala.jdk.CollectionConverters.*
final case class BuildPhase(
    phaseType: Option[zio.aws.codebuild.model.BuildPhaseType] = None,
    phaseStatus: Option[zio.aws.codebuild.model.StatusType] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    durationInSeconds: Option[WrapperLong] = None,
    contexts: Option[Iterable[zio.aws.codebuild.model.PhaseContext]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.BuildPhase = {
    import BuildPhase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.BuildPhase
      .builder()
      .optionallyWith(phaseType.map(value => value.unwrap))(_.phaseType)
      .optionallyWith(phaseStatus.map(value => value.unwrap))(_.phaseStatus)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        durationInSeconds.map(value =>
          WrapperLong.unwrap(value): java.lang.Long
        )
      )(_.durationInSeconds)
      .optionallyWith(
        contexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contexts)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.BuildPhase.ReadOnly =
    zio.aws.codebuild.model.BuildPhase.wrap(buildAwsValue())
}
object BuildPhase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.BuildPhase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.BuildPhase =
      zio.aws.codebuild.model.BuildPhase(
        phaseType.map(value => value),
        phaseStatus.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        durationInSeconds.map(value => value),
        contexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def phaseType: Option[zio.aws.codebuild.model.BuildPhaseType]
    def phaseStatus: Option[zio.aws.codebuild.model.StatusType]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def durationInSeconds: Option[WrapperLong]
    def contexts: Option[List[zio.aws.codebuild.model.PhaseContext.ReadOnly]]
    def getPhaseType
        : ZIO[Any, AwsError, zio.aws.codebuild.model.BuildPhaseType] =
      AwsError.unwrapOptionField("phaseType", phaseType)
    def getPhaseStatus: ZIO[Any, AwsError, zio.aws.codebuild.model.StatusType] =
      AwsError.unwrapOptionField("phaseStatus", phaseStatus)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDurationInSeconds: ZIO[Any, AwsError, WrapperLong] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
    def getContexts: ZIO[Any, AwsError, List[
      zio.aws.codebuild.model.PhaseContext.ReadOnly
    ]] = AwsError.unwrapOptionField("contexts", contexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.BuildPhase
  ) extends zio.aws.codebuild.model.BuildPhase.ReadOnly {
    override val phaseType: Option[zio.aws.codebuild.model.BuildPhaseType] =
      scala
        .Option(impl.phaseType())
        .map(value => zio.aws.codebuild.model.BuildPhaseType.wrap(value))
    override val phaseStatus: Option[zio.aws.codebuild.model.StatusType] = scala
      .Option(impl.phaseStatus())
      .map(value => zio.aws.codebuild.model.StatusType.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codebuild.model.primitives.Timestamp(value))
    override val durationInSeconds: Option[WrapperLong] = scala
      .Option(impl.durationInSeconds())
      .map(value => zio.aws.codebuild.model.primitives.WrapperLong(value))
    override val contexts
        : Option[List[zio.aws.codebuild.model.PhaseContext.ReadOnly]] = scala
      .Option(impl.contexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.PhaseContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.BuildPhase
  ): zio.aws.codebuild.model.BuildPhase.ReadOnly = new Wrapper(impl)
}
