package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsConfig(
    status: zio.aws.codebuild.model.LogsConfigStatusType,
    groupName: Option[String] = None,
    streamName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig = {
    import CloudWatchLogsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig
      .builder()
      .status(status.unwrap)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(streamName.map(value => value: java.lang.String))(
        _.streamName
      )
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly =
    zio.aws.codebuild.model.CloudWatchLogsConfig.wrap(buildAwsValue())
}
object CloudWatchLogsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CloudWatchLogsConfig =
      zio.aws.codebuild.model.CloudWatchLogsConfig(
        status,
        groupName.map(value => value),
        streamName.map(value => value)
      )
    def status: zio.aws.codebuild.model.LogsConfigStatusType
    def groupName: Option[String]
    def streamName: Option[String]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codebuild.model.LogsConfigStatusType] =
      ZIO.succeed(status)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamName", streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig
  ) extends zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly {
    override val status: zio.aws.codebuild.model.LogsConfigStatusType =
      zio.aws.codebuild.model.LogsConfigStatusType.wrap(impl.status())
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val streamName: Option[String] =
      scala.Option(impl.streamName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CloudWatchLogsConfig
  ): zio.aws.codebuild.model.CloudWatchLogsConfig.ReadOnly = new Wrapper(impl)
}
