package zio.aws.codebuild.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codebuild.model.primitives.{NonNegativeInt, Percentage}
import scala.jdk.CollectionConverters.*
final case class CodeCoverageReportSummary(
    lineCoveragePercentage: Option[Percentage] = None,
    linesCovered: Option[NonNegativeInt] = None,
    linesMissed: Option[NonNegativeInt] = None,
    branchCoveragePercentage: Option[Percentage] = None,
    branchesCovered: Option[NonNegativeInt] = None,
    branchesMissed: Option[NonNegativeInt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary = {
    import CodeCoverageReportSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
      .builder()
      .optionallyWith(
        lineCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.lineCoveragePercentage)
      .optionallyWith(
        linesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesCovered)
      .optionallyWith(
        linesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.linesMissed)
      .optionallyWith(
        branchCoveragePercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.branchCoveragePercentage)
      .optionallyWith(
        branchesCovered.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesCovered)
      .optionallyWith(
        branchesMissed.map(value => NonNegativeInt.unwrap(value): Integer)
      )(_.branchesMissed)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly =
    zio.aws.codebuild.model.CodeCoverageReportSummary.wrap(buildAwsValue())
}
object CodeCoverageReportSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.CodeCoverageReportSummary =
      zio.aws.codebuild.model.CodeCoverageReportSummary(
        lineCoveragePercentage.map(value => value),
        linesCovered.map(value => value),
        linesMissed.map(value => value),
        branchCoveragePercentage.map(value => value),
        branchesCovered.map(value => value),
        branchesMissed.map(value => value)
      )
    def lineCoveragePercentage: Option[Percentage]
    def linesCovered: Option[NonNegativeInt]
    def linesMissed: Option[NonNegativeInt]
    def branchCoveragePercentage: Option[Percentage]
    def branchesCovered: Option[NonNegativeInt]
    def branchesMissed: Option[NonNegativeInt]
    def getLineCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("lineCoveragePercentage", lineCoveragePercentage)
    def getLinesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesCovered", linesCovered)
    def getLinesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("linesMissed", linesMissed)
    def getBranchCoveragePercentage: ZIO[Any, AwsError, Percentage] = AwsError
      .unwrapOptionField("branchCoveragePercentage", branchCoveragePercentage)
    def getBranchesCovered: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesCovered", branchesCovered)
    def getBranchesMissed: ZIO[Any, AwsError, NonNegativeInt] =
      AwsError.unwrapOptionField("branchesMissed", branchesMissed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
  ) extends zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly {
    override val lineCoveragePercentage: Option[Percentage] = scala
      .Option(impl.lineCoveragePercentage())
      .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val linesCovered: Option[NonNegativeInt] = scala
      .Option(impl.linesCovered())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val linesMissed: Option[NonNegativeInt] = scala
      .Option(impl.linesMissed())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchCoveragePercentage: Option[Percentage] = scala
      .Option(impl.branchCoveragePercentage())
      .map(value => zio.aws.codebuild.model.primitives.Percentage(value))
    override val branchesCovered: Option[NonNegativeInt] = scala
      .Option(impl.branchesCovered())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
    override val branchesMissed: Option[NonNegativeInt] = scala
      .Option(impl.branchesMissed())
      .map(value => zio.aws.codebuild.model.primitives.NonNegativeInt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.CodeCoverageReportSummary
  ): zio.aws.codebuild.model.CodeCoverageReportSummary.ReadOnly = new Wrapper(
    impl
  )
}
