package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codebuild.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class DeleteSourceCredentialsRequest(arn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest = {
    import DeleteSourceCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest
      .builder()
      .arn(NonEmptyString.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codebuild.model.DeleteSourceCredentialsRequest.ReadOnly =
    zio.aws.codebuild.model.DeleteSourceCredentialsRequest.wrap(buildAwsValue())
}
object DeleteSourceCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DeleteSourceCredentialsRequest =
      zio.aws.codebuild.model.DeleteSourceCredentialsRequest(arn)
    def arn: NonEmptyString
    def getArn: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest
  ) extends zio.aws.codebuild.model.DeleteSourceCredentialsRequest.ReadOnly {
    override val arn: NonEmptyString =
      zio.aws.codebuild.model.primitives.NonEmptyString(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DeleteSourceCredentialsRequest
  ): zio.aws.codebuild.model.DeleteSourceCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
