package zio.aws.codebuild.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTestCasesResponse(
    nextToken: Option[String] = None,
    testCases: Option[Iterable[zio.aws.codebuild.model.TestCase]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse = {
    import DescribeTestCasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        testCases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testCases)
      .build()
  }
  def asReadOnly: zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly =
    zio.aws.codebuild.model.DescribeTestCasesResponse.wrap(buildAwsValue())
}
object DescribeTestCasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codebuild.model.DescribeTestCasesResponse =
      zio.aws.codebuild.model.DescribeTestCasesResponse(
        nextToken.map(value => value),
        testCases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def testCases: Option[List[zio.aws.codebuild.model.TestCase.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTestCases
        : ZIO[Any, AwsError, List[zio.aws.codebuild.model.TestCase.ReadOnly]] =
      AwsError.unwrapOptionField("testCases", testCases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse
  ) extends zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val testCases
        : Option[List[zio.aws.codebuild.model.TestCase.ReadOnly]] = scala
      .Option(impl.testCases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codebuild.model.TestCase.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codebuild.model.DescribeTestCasesResponse
  ): zio.aws.codebuild.model.DescribeTestCasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
